/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.event;

import com.tandbergtv.watchpoint.boot.Platform;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.monitor.event.IEventHandlerRegistry;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;

public class EventHandlerRegistry
implements IEventHandlerRegistry {
    private Set<IColleague> colleagues;
    private static final Logger logger = Logger.getLogger(EventHandlerRegistry.class);

    public void start() {
        this.colleagues = new HashSet<IColleague>();
        this.registerEventHandlers();
    }

    public void stop() {
        this.unregisterEventHandlers();
        this.colleagues.clear();
    }

    public String getServiceName() {
        return this.getClass().getSimpleName();
    }

    private void registerEventHandlers() {
        PluginManager pm = Platform.getPlatform().getPluginManager();
        try {
            ExtensionPoint ep = pm.getRegistry().getExtensionPoint("com.tandbergtv.workflow", "colleague");
            for (Extension e : ep.getAvailableExtensions()) {
                PluginDescriptor plugin = e.getDeclaringPluginDescriptor();
                PluginClassLoader cl = pm.getPluginClassLoader(plugin);
                this.registerEventHandler(e, (ClassLoader)cl);
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)"Extension point for IColleague implementations does not exist, old plugin definition?");
        }
    }

    private void registerEventHandler(Extension e, ClassLoader loader) {
        IMediator mediator = DefaultMediator.getInstance();
        try {
            String className = e.getParameter("class").valueAsString();
            Class<?> clazz = loader.loadClass(className);
            IColleague c = (IColleague)clazz.newInstance();
            String topics = e.getParameter("topics").valueAsString();
            logger.debug((Object)("Created colleague " + c.getClass().getName() + " with " + topics));
            mediator.register(c);
            this.colleagues.add(c);
        }
        catch (Throwable e1) {
            logger.warn((Object)("Colleague could not be registered for extension " + e), e1);
        }
    }

    private void unregisterEventHandlers() {
        IMediator mediator = DefaultMediator.getInstance();
        for (IColleague c : this.colleagues) {
            mediator.unregister(c);
        }
    }
}

