/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.sanmanager.boot;

import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import com.tandbergtv.workflow.sanmanager.SANManagement;
import com.tandbergtv.workflow.sanmanager.internal.SANManager;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class Activator {
    private static final String TARGET_DESTINATION_NAME = "File Subsystem";
    private static final String DRIVE_SERVICE_URL_PROPERTY = "SANManager.ServiceURL";
    private static final long DEFAULT_SAN_DRIVE_UPDATE_FREQUENCY = 300L;

    public void start() {
        String url = this.getFileSubsystemServiceURL();
        IDestination destination = this.createDestination(url);
        long frequency = this.getDriveUpdateFrequency();
        SANManager sanmanager = new SANManager(HibernateUtil.getSessionFactory(), destination, frequency);
        ServiceRegistry.getDefault().register(sanmanager.getServiceName(), (Service)sanmanager);
        sanmanager.start();
    }

    public void stop() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        SANManagement sanmanager = (SANManagement)registry.lookup(SANManagement.class);
        if (sanmanager != null) {
            registry.unregister((Service)sanmanager);
            sanmanager.stop();
        }
    }

    private long getDriveUpdateFrequency() {
        long frequency = 300L;
        try {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            String frequencyValue = properties.getProperty("SANManager.DriveUpdateFrequency");
            frequency = Long.parseLong(frequencyValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return frequency;
    }

    private String getFileSubsystemServiceURL() {
        String url = null;
        try {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            url = properties.getProperty(DRIVE_SERVICE_URL_PROPERTY);
            if (url == null || url.trim().length() == 0) {
                String msg = "No webservice URL specified in the application properties for the SAN Configuration.";
                throw new RuntimeException(msg);
            }
            new URL(url);
        }
        catch (MalformedURLException mue) {
            String msg = "The webservice URL specified in the application properties for the SAN Configuration is invalid.";
            throw new RuntimeException(msg, mue);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    private IDestination createDestination(String url) {
        String connectionType = ResourceConnectionType.URL.getDisplayName();
        IDestination destination = (IDestination)DeviceTypeUtil.createDevice((String)connectionType, (String)url, (String)TARGET_DESTINATION_NAME);
        return destination;
    }
}

