/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.log.Finder;
import com.tandbergtv.workflow.log.LogSyncCallable;
import com.tandbergtv.workflow.log.LogSyncState;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class LogSyncService
implements Service {
    private Finder finder;
    private ISchedulerService<Void> scheduler;
    private ISchedulerService<Long> syncScheduler;
    private String dir;
    private long period;
    private static final int POOL_SIZE = 10;
    private static final Logger logger = Logger.getLogger(LogSyncService.class);

    public LogSyncService(SessionFactory factory, String dir, long period) {
        this.finder = new Finder(factory);
        this.scheduler = new Scheduler("logger-sync", 1, 1);
        this.syncScheduler = new Scheduler("sync-pool", 10, 10);
        this.dir = dir;
        this.period = period;
    }

    public void start() {
        this.syncScheduler.start();
        this.scheduler.start();
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                LogSyncService.this.write();
            }
        }, 0L, this.period * 1000L);
    }

    public void stop() {
        this.syncScheduler.stop();
        this.scheduler.stop();
    }

    public String getServiceName() {
        return "log-sync";
    }

    private void write() {
        LogSyncState state = new LogSyncState(this.dir);
        try {
            ArrayList<Long> list;
            long windowEnd;
            long windowStart;
            if (state.lastRunWasSuccessful()) {
                windowStart = state.getLastSuccessfulRunTime();
                windowEnd = System.currentTimeMillis();
                state.setWindow(windowStart, windowEnd);
                list = this.finder.findUpdatedBetween(new Date(windowStart), new Date(windowEnd));
                state.setMasterIds(list);
                logger.debug((Object)("Found " + list.size() + " between " + this.format(new Date(windowStart)) + " and " + this.format(new Date(windowEnd))));
            } else {
                long[] window = state.getWindow();
                windowStart = window[0];
                windowEnd = window[1];
                list = new ArrayList<Long>();
                list.addAll(state.getPendingIds(this.finder, windowStart));
            }
            if (windowStart == 0L) {
                logger.info((Object)"Initializing sync time because no existing state info (This should only happen once!)");
                state.setSyncComplete(windowEnd);
                return;
            }
            if (list.isEmpty()) {
                state.setSyncComplete(windowEnd);
                return;
            }
            HashSet<Future> futures = new HashSet<Future>();
            for (LogSyncCallable sync : this.partition(list, windowStart, windowEnd)) {
                futures.add(this.syncScheduler.schedule((Callable)sync));
            }
            for (Future future : futures) {
                future.get();
            }
            state.setSyncComplete(windowEnd);
        }
        catch (Throwable t) {
            logger.error((Object)":(", t);
        }
    }

    private Collection<LogSyncCallable> partition(List<Long> list, long windowStart, long windowEnd) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<LogSyncCallable> callables = new ArrayList<LogSyncCallable>();
        int size = list.size();
        if (size <= 10) {
            return Collections.singleton(this.createCallable(list, 0, windowStart, windowEnd));
        }
        int count = (int)Math.ceil((double)size * 1.0 / 10.0);
        int start = 0;
        for (int i = 0; i < 10 && start < size; start += count, ++i) {
            int end = Math.min(start + count, size);
            logger.debug((Object)("Thread " + i + " start " + start + ", end " + end));
            callables.add(this.createCallable(list.subList(start, end), i, windowStart, windowEnd));
        }
        return callables;
    }

    private LogSyncCallable createCallable(List<Long> list, int threadNum, long windowStart, long windowEnd) {
        return new LogSyncCallable(this.getSessionFactory(), Collections.unmodifiableSet(new HashSet<Long>(list)), this.dir, threadNum, windowStart, windowEnd);
    }

    private SessionFactory getSessionFactory() {
        return this.finder.getSessionFactory();
    }

    private String format(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }
}

