/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.log.EventDeserializer;
import com.tandbergtv.workflow.log.EventSerializer;
import com.tandbergtv.workflow.log.Finder;
import com.tandbergtv.workflow.log.LogEventListener;
import com.tandbergtv.workflow.log.SortColumnEnum;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.log.file.FileNameMatcher;
import com.tandbergtv.workflow.log.file.GarbageCollector;
import com.tandbergtv.workflow.log.file.LogFileNames;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.SessionFactory;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;

public class WorkflowLogService
implements Service {
    private LogEventListener listener;
    private GarbageCollector collector;
    private Scheduler<Void> scheduler;
    private String dir;
    private long period;

    public WorkflowLogService(SessionFactory factory, String rootdir, Long period, Long window) {
        Finder finder = new Finder(factory);
        this.listener = new LogEventListener(new EventSerializer(rootdir));
        this.collector = new GarbageCollector(rootdir, window, finder);
        this.scheduler = new Scheduler("log-delete", 1, 1);
        this.period = period;
        this.dir = rootdir;
    }

    public void start() {
        this.scheduler.start();
        this.scheduler.schedule((Runnable)this.collector, 0L, this.period * 1000L);
        DefaultMediator.getInstance().register((IColleague)this.listener);
    }

    public void stop() {
        this.scheduler.stop();
        DefaultMediator.getInstance().unregister((IColleague)this.listener);
    }

    public String getServiceName() {
        return "process-logger";
    }

    private boolean hasLogs(long id) {
        File f = new File(Directories.pathFor(this.dir, id));
        return f.exists() && f.isDirectory();
    }

    public List<NodeLog> findNodeLogs(WorkflowProcess process, Integer count, Integer start) {
        if (!this.hasLogs(process.getId())) {
            return null;
        }
        if (count == null) {
            start = 0;
            count = 25;
        }
        ArrayList<NodeLog> result = new ArrayList<NodeLog>();
        File[] allLogFiles = this.getNodeLogFiles(process);
        LogFileNames.sortFiles(allLogFiles, null, false);
        File[] currentPage = new File[allLogFiles.length - start < count ? allLogFiles.length - start : count];
        System.arraycopy(allLogFiles, start, currentPage, 0, currentPage.length);
        for (File file : currentPage) {
            long tokenId = LogFileNames.getTokenId(file.getName());
            NodeLog nodeLog = EventDeserializer.deSerializeNodeLog((Token)process.findToken(tokenId), file);
            if (nodeLog == null) continue;
            result.add(nodeLog);
        }
        return result;
    }

    public Integer getNodeLogCount(WorkflowProcess process) {
        if (!this.hasLogs(process.getId())) {
            return null;
        }
        return this.getNodeLogFiles(process).length;
    }

    private File[] getNodeLogFiles(WorkflowProcess process) {
        File[] files = Directories.list(new File(Directories.pathFor(this.dir, process.getId())), this.matchByType("-nodeLog"));
        int numFiles = 0;
        for (int i = 0; i < files.length; ++i) {
            long tokenId = LogFileNames.getTokenId(files[i].getName());
            if (EventDeserializer.skipDeserialize((Token)process.findToken(tokenId), files[i])) continue;
            files[numFiles] = files[i];
            ++numFiles;
        }
        File[] deserializableFiles = new File[numFiles];
        System.arraycopy(files, 0, deserializableFiles, 0, numFiles);
        return deserializableFiles;
    }

    public List<WorkflowMessageLog> findMessageLogs(long id, long time, Integer count, Integer start, String sortColumn, Boolean descending) {
        if (!this.hasLogs(id)) {
            return null;
        }
        if (count == null || start == null || sortColumn == null || descending == null) {
            count = Integer.MAX_VALUE;
            start = 0;
            sortColumn = SortColumnEnum.timestamp.toString();
            descending = Boolean.TRUE;
        }
        ArrayList<WorkflowMessageLog> result = new ArrayList<WorkflowMessageLog>();
        long[] tokenIdAndNodeId = this.getTokenIdAndNodeId(id, time);
        File[] files = this.getPreviousMessageLogFiles(id, time, tokenIdAndNodeId[0], tokenIdAndNodeId[1]);
        if (files != null && files.length > 0) {
            LogFileNames.sortFiles(files, sortColumn, descending);
            File[] currentPage = new File[files.length - start < count ? files.length - start : count];
            System.arraycopy(files, start, currentPage, 0, currentPage.length);
            for (File file : currentPage) {
                WorkflowMessageLog log = EventDeserializer.deSerializeMessageLog(file);
                if (log == null) continue;
                result.add(log);
            }
        }
        return result;
    }

    public Integer getMessageLogsCount(long id, long time) {
        if (!this.hasLogs(id)) {
            return null;
        }
        long[] tokenIdAndNodeId = this.getTokenIdAndNodeId(id, time);
        long tokenId = tokenIdAndNodeId[0];
        long nodeId = tokenIdAndNodeId[1];
        File[] files = this.getPreviousMessageLogFiles(id, time, tokenId, nodeId);
        return files.length;
    }

    private File[] getPreviousMessageLogFiles(long id, final long time, final long tokenId, final long nodeId) {
        FileNameMatcher matcher = new FileNameMatcher(){

            @Override
            public boolean match(String name) {
                if (name.endsWith("-resourceLog")) {
                    return false;
                }
                long fileTokenId = LogFileNames.getTokenId(name);
                long fileNodeId = LogFileNames.getNodeId(name);
                long timestamp = LogFileNames.extractFileTimestamp(name);
                return fileTokenId == tokenId && fileNodeId == nodeId && timestamp <= time;
            }
        };
        File[] files = Directories.list(new File(Directories.pathFor(this.dir, id)), matcher);
        LogFileNames.sortFiles(files, null, true);
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            String name = file.getName();
            if (name.endsWith("-messageLog")) {
                result.add(0, file);
                continue;
            }
            if (name.endsWith("-nodeLog") && LogFileNames.extractFileTimestamp(name) < time) break;
        }
        return result.toArray(new File[result.size()]);
    }

    private long[] getTokenIdAndNodeId(long id, long prefix) {
        File file = this.getLogFileByPrefix(id, prefix);
        long tokenId = LogFileNames.getTokenId(file.getName());
        long nodeId = LogFileNames.getNodeId(file.getName());
        return new long[]{tokenId, nodeId};
    }

    private File getLogFileByPrefix(long id, final long prefix) {
        FileNameMatcher matcher = new FileNameMatcher(){

            @Override
            public boolean match(String name) {
                return name.startsWith(prefix + "-") && (name.endsWith("-nodeLog") || name.endsWith("-messageLog"));
            }
        };
        File[] files = Directories.list(new File(Directories.pathFor(this.dir, id)), matcher);
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    public Long getCurrentNodeMessageLogId(long id, final long tokenId, final long nodeId) {
        if (!this.hasLogs(id)) {
            return null;
        }
        String directoryPath = Directories.pathFor(this.dir, id);
        File dir = new File(directoryPath);
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(tokenId + "-" + nodeId + "-nodeLog") || name.endsWith(tokenId + "-" + nodeId + "-messageLog");
            }
        });
        if (files != null && files.length > 0) {
            LogFileNames.sortFiles(files, null, true);
            long latestNodeLogOrMessageLogId = -1L;
            if (files[0].getName().endsWith("-messageLog")) {
                latestNodeLogOrMessageLogId = LogFileNames.extractFileTimestamp(files[0].getName());
            }
            return latestNodeLogOrMessageLogId;
        }
        return new Long(-1L);
    }

    public int getNodeIteration(long id, final long time) {
        if (!this.hasLogs(id)) {
            return -1;
        }
        long[] tokenIdAndNodeId = this.getTokenIdAndNodeId(id, time);
        final long tokenId = tokenIdAndNodeId[0];
        final long nodeId = tokenIdAndNodeId[1];
        FileNameMatcher matcher = new FileNameMatcher(){

            @Override
            public boolean match(String name) {
                if (name.endsWith("-nodeLog")) {
                    long fileTokenId = LogFileNames.getTokenId(name);
                    long fileNodeId = LogFileNames.getNodeId(name);
                    Long timestamp = LogFileNames.extractFileTimestamp(name);
                    return fileTokenId == tokenId && fileNodeId == nodeId && timestamp <= time;
                }
                return false;
            }
        };
        File[] files = Directories.list(new File(Directories.pathFor(this.dir, id)), matcher);
        return files.length;
    }

    public int getNodeNumIterations(long id, long time) {
        if (!this.hasLogs(id)) {
            return -1;
        }
        long[] tokenIdAndNodeId = this.getTokenIdAndNodeId(id, time);
        long tokenId = tokenIdAndNodeId[0];
        long nodeId = tokenIdAndNodeId[1];
        File[] files = Directories.list(new File(Directories.pathFor(this.dir, id)), this.matchByType("-nodeLog"), this.matchByNode(tokenId, nodeId));
        return files.length;
    }

    private FileNameMatcher matchByType(final String type) {
        return new FileNameMatcher(){

            @Override
            public boolean match(String name) {
                return name.endsWith(type);
            }
        };
    }

    private FileNameMatcher matchByNode(final long tokenId, final long nodeId) {
        return new FileNameMatcher(){

            @Override
            public boolean match(String name) {
                return LogFileNames.getTokenId(name) == tokenId && LogFileNames.getNodeId(name) == nodeId;
            }
        };
    }
}

