/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class MailNode
extends Node {
    private static final String DEFAULT_MAIL_CLASS_NAME = "com.tandbergtv.workflow.exe.email.Mail";
    private String to;
    private String subject;
    private String text;
    private String attachment;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MailNode.class);

    public String getTo() {
        return this.to;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getText() {
        return this.text;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void read(Element element, JpdlXmlReader jpdlReader) {
        this.to = element.attributeValue("to");
        this.subject = this.getProperty("subject", element);
        this.text = this.getProperty("text", element);
        this.attachment = element.attributeValue("attachment");
        Delegation delegation = this.createMailDelegation(this.to, this.subject, this.text, this.attachment);
        this.action = new Action(delegation);
    }

    protected String getProperty(String property, Element element) {
        Element propertyElement;
        String value = element.attributeValue(property);
        if (value == null && (propertyElement = element.element(property)) != null) {
            value = propertyElement.getText();
        }
        return value;
    }

    protected Delegation createMailDelegation(String to, String subject, String text, String attachment) {
        StringBuffer config = new StringBuffer();
        if (to != null) {
            config.append("<to>");
            config.append(to);
            config.append("</to>");
        }
        if (subject != null) {
            config.append("<subject>");
            config.append(subject);
            config.append("</subject>");
        }
        if (attachment != null) {
            config.append("<attachment>");
            config.append(attachment);
            config.append("</attachment>");
        }
        if (text != null) {
            config.append("<text>");
            config.append(text);
            config.append("</text>");
        }
        String mailClassName = DEFAULT_MAIL_CLASS_NAME;
        if (JbpmConfiguration.Configs.hasObject((String)"mail.action.class.name")) {
            mailClassName = JbpmConfiguration.Configs.getString((String)"mail.action.class.name");
        }
        Delegation delegation = new Delegation(mailClassName);
        delegation.setProcessDefinition(this.processDefinition);
        delegation.setConfiguration(config.toString());
        return delegation;
    }

    public void execute(ExecutionContext executionContext) {
        CustomToken token = (CustomToken)executionContext.getToken();
        logger.info((Object)(token + " (" + this.name + ")"));
        try {
            this.action.execute(executionContext);
        }
        catch (Throwable t) {
            try {
                this.raiseException(t, executionContext);
            }
            catch (DelegationException e) {
                logger.warn((Object)(token + ", no exception handler defined for template - " + this.processDefinition.getName()), t);
                token.fail();
            }
        }
        if (token.getStatus() == ProcessStatus.RUNNING) {
            this.leave(executionContext);
        }
    }
}

