/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph.exe;

import com.tandbergtv.workflow.core.AbstractTaskNode;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.graph.Loop;
import java.util.List;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.Decision;

public final class Transitions {
    public static Transition createDefaultLeavingTransition(Node node) {
        if (Transitions.needsLeavingTransition(node)) {
            return Transitions.leavingTransitionFor(node);
        }
        return null;
    }

    private static boolean needsLeavingTransition(Node node) {
        List transitions;
        SuperState superState;
        if (node instanceof Decision && (superState = node.getSuperState()) != null && superState.getParent() instanceof Loop && ((transitions = superState.getLeavingTransitions()) == null || transitions.isEmpty())) {
            return true;
        }
        return node.getLeavingTransitions() == null || node.getLeavingTransitions().isEmpty();
    }

    private static Transition leavingTransitionFor(final Node node) {
        Transition transition = new Transition(){
            private static final long serialVersionUID = 1L;

            public void take(ExecutionContext context) {
                this.fireEvent("transition", context);
                SuperState parent = node.getSuperState();
                if (parent instanceof NodeGroup) {
                    parent.leave(context);
                }
            }
        };
        transition.setFrom(node);
        transition.setProcessDefinition(node.getProcessDefinition());
        if (Transitions.shouldAddEvent(node)) {
            Transitions.addEvent(transition, "resource-release");
        }
        return transition;
    }

    private static boolean shouldAddEvent(Node node) {
        if (node instanceof Loop || node instanceof Decision) {
            return true;
        }
        if (node instanceof AbstractTaskNode) {
            AbstractTaskNode n = (AbstractTaskNode)node;
            return n.getResourceGroupID() != null || n.getSuperState() instanceof NodeGroup;
        }
        return false;
    }

    private static void addEvent(Transition transition, String action) {
        Event event = new Event((GraphElement)transition, "transition");
        Action a = transition.getProcessDefinition().getAction(action);
        event.addAction(new Action(a.getActionDelegation()));
        transition.addEvent(event);
    }
}

