/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.ui.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.encoders.KeypointPNGEncoderAdapter;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class ImageGenerator {
    public BufferedImage createImage(XYDataset data, String legend, String x, String y, int w, int h) {
        JFreeChart chart = this.createTimeSeriesChart(data, legend, x, y);
        return this.createImage(chart, w, h);
    }

    public byte[] createImageBytes(XYDataset data, String legend, String x, String y, int w, int h) {
        JFreeChart chart = this.createTimeSeriesChart(data, legend, x, y);
        return this.createBytes(chart, w, h);
    }

    protected JFreeChart createTimeSeriesChart(XYDataset data, String legend, String x, String y) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)legend, (String)x, (String)y, (XYDataset)data, (boolean)true, (boolean)false, (boolean)false);
        return this.setDecoration(chart);
    }

    protected BufferedImage createImage(JFreeChart chart, int w, int h) {
        return chart.createBufferedImage(w, h, 2, null);
    }

    protected byte[] createBytes(JFreeChart chart, int w, int h) {
        byte[] buffer = null;
        KeypointPNGEncoderAdapter encoder = new KeypointPNGEncoderAdapter();
        encoder.setEncodingAlpha(true);
        try {
            buffer = encoder.encode(this.createImage(chart, w, h));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer;
    }

    protected JFreeChart setDecoration(JFreeChart chart) {
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYSplineRenderer splineRenderer = new XYSplineRenderer();
        splineRenderer.setSeriesShapesVisible(0, false);
        splineRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(4.0f, 1, 1, 1.0f, null, 0.0f));
        splineRenderer.setSeriesPaint(0, (Paint)new Color(255, 140, 0));
        plot.setRenderer(0, (XYItemRenderer)splineRenderer);
        if (plot.getDomainAxis() instanceof DateAxis) {
            DateAxis axis = (DateAxis)plot.getDomainAxis();
            axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm"));
        }
        ValueAxis vaxis = plot.getRangeAxis();
        vaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }
}

