/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.core;

import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.monitor.core.IObserver;
import com.tandbergtv.workflow.monitor.core.IRecorder;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class Recorder
implements IRecorder {
    protected ISchedulerService<Void> pool;
    protected String name;
    protected Set<IObserver> observers;

    public Recorder(ISchedulerService<Void> pool, String name) {
        this.pool = pool;
        this.name = name;
        this.observers = new HashSet<IObserver>();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public Set<IObserver> getObservers() {
        return this.observers;
    }

    public void start() {
        this.pool.start();
        this.pool.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    Recorder.this.record();
                }
                catch (Throwable t) {
                    Logger.getLogger(Recorder.class).warn((Object)t.getMessage());
                }
            }
        }, 0L, 10000L);
    }

    public void stop() {
        this.observers.clear();
        this.pool.stop();
    }

    public String getServiceName() {
        return this.name;
    }
}

