/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import com.tandbergtv.workflow.driver.search.ISearchHelper;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.search.WorkflowProcessSearchHelper;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class SearchService
implements IProcessSearchService {
    private SessionFactory factory;
    public static final String SERVICE_NAME = "Process Search Service";

    public SearchService(SessionFactory factory) {
        this.factory = factory;
    }

    @Override
    public int count(SearchCriteria criteria) {
        return this.getSearchHelper().count(criteria);
    }

    @Override
    public IProcessMonitor statistics(SearchCriteria criteria) {
        return this.getSearchHelper().statistics(criteria);
    }

    @Override
    public int count(ProcessStatus status) {
        SearchCriteria criteria = new SearchCriteria();
        criteria.addParameter((SearchParameterBase)new ValueParameter("status", SearchType.PROCESSSTATUS, (Object)status));
        criteria.setSearchDistinct(false);
        return this.count(criteria);
    }

    @Override
    public int count(ProcessStatus status, Date cutOffDate) {
        SearchCriteria criteria = new SearchCriteria();
        ValueParameter parameter = new ValueParameter("status", SearchType.PROCESSSTATUS, (Object)status);
        String date = new SimpleDateFormat("yyyy-MM-dd").format(cutOffDate);
        RangeParameter rangeParam = new RangeParameter("start", SearchType.DATE, false);
        rangeParam.setFrom(date);
        criteria.addParameter((SearchParameterBase)parameter);
        criteria.addParameter((SearchParameterBase)rangeParam);
        criteria.setSearchDistinct(false);
        return this.count(criteria);
    }

    @Override
    public int count(List<ProcessStatus> statuslist) {
        ListParameter parameter = new ListParameter("status", SearchType.PROCESSSTATUS);
        for (ProcessStatus status : statuslist) {
            parameter.addValue((Object)status);
        }
        SearchCriteria criteria = new SearchCriteria();
        criteria.addParameter((SearchParameterBase)parameter);
        criteria.setSearchDistinct(false);
        return this.count(criteria);
    }

    @Override
    public int count(WorkflowTemplate template, ProcessStatus ... status) {
        Session session = null;
        int count = 0;
        try {
            session = this.factory.openSession();
            Criteria criteria = session.createCriteria(WorkflowProcess.class).add(Restrictions.in((String)"status", (Object[])status)).add((Criterion)Restrictions.eq((String)"active", (Object)true)).add((Criterion)Restrictions.eq((String)"processDefinition.id", (Object)template.getId())).setProjection(Projections.rowCount()).createCriteria("processDefinition").add(Restrictions.sqlRestriction((String)"processDefinitionTypeId=2"));
            count = (Integer)criteria.uniqueResult();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return count;
    }

    @Override
    public List<WorkflowProcess> findAllByStatus(ProcessStatus status) {
        return this.findAllByStatus((List<ProcessStatus>)new ArrayList<ProcessStatus>(status){
            {
                this.add(processStatus);
            }
        });
    }

    @Override
    public List<WorkflowProcess> findAllByStatus(List<ProcessStatus> statuslist) {
        SearchCriteria criteria = new SearchCriteria();
        ListParameter parameter = new ListParameter("status", SearchType.PROCESSSTATUS);
        for (ProcessStatus status : statuslist) {
            parameter.addValue((Object)status);
        }
        criteria.addParameter((SearchParameterBase)parameter);
        criteria.setSearchDistinct(false);
        List<WorkflowProcess> list = this.search(criteria);
        return list;
    }

    @Override
    public List<WorkflowProcess> findAllByStatus(ProcessStatus ... statuslist) {
        ArrayList<ProcessStatus> list = new ArrayList<ProcessStatus>();
        ProcessStatus[] processStatusArray = statuslist;
        int n = statuslist.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessStatus status = processStatusArray[n2];
            list.add(status);
            ++n2;
        }
        return this.findAllByStatus(list);
    }

    @Override
    public List<WorkflowProcess> search(SearchCriteria searchCriteria) {
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
        ArrayList<WorkflowProcess> processes = new ArrayList<WorkflowProcess>();
        for (WorkflowProcess process : this.getSearchHelper().search(searchCriteria)) {
            Long key = process.getId();
            WorkflowProcess cached = (WorkflowProcess)cache.get((Serializable)key);
            if (cached != null) {
                processes.add(cached);
                continue;
            }
            processes.add(process);
        }
        return processes;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
    }

    public void stop() {
    }

    private ISearchHelper getSearchHelper() {
        return new WorkflowProcessSearchHelper(this.factory);
    }
}

