/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.exceptionhandler;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.message.WorkflowMessage;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class CatchExceptionHandler
implements ActionHandler {
    private static final Logger logger = Logger.getLogger(CatchExceptionHandler.class);
    private static final long serialVersionUID = -4318000928186071464L;
    private String errorCodeVariable;
    private String errorMessageVariable;
    private String errorHintVariable;

    private void setExceptionVariables(WorkflowMessage workflowMessage, ExecutionContext context) {
        this.errorCodeVariable = this.errorCodeVariable.trim();
        this.errorMessageVariable = this.errorMessageVariable.trim();
        this.errorHintVariable = this.errorHintVariable.trim();
        ContextInstance contextInstance = context.getContextInstance();
        if (!this.errorCodeVariable.isEmpty()) {
            if (contextInstance.hasVariable(this.errorCodeVariable)) {
                String errorCode = (String)workflowMessage.getParameterValue("error-code");
                contextInstance.setVariable(this.errorCodeVariable, (Object)Integer.valueOf(errorCode));
            } else {
                logger.warn((Object)("errorCode variable [" + this.errorCodeVariable + "] is not defined."));
            }
        }
        if (!this.errorMessageVariable.isEmpty()) {
            if (contextInstance.hasVariable(this.errorMessageVariable)) {
                String errorMessage = (String)workflowMessage.getParameterValue("error-message");
                contextInstance.setVariable(this.errorMessageVariable, (Object)errorMessage);
            } else {
                logger.warn((Object)("errorMessage variable [" + this.errorMessageVariable + "] is not defined."));
            }
        }
        if (!this.errorHintVariable.isEmpty()) {
            if (contextInstance.hasVariable(this.errorHintVariable)) {
                String errorHint = (String)workflowMessage.getParameterValue("error-hint");
                contextInstance.setVariable(this.errorHintVariable, (Object)errorHint);
            } else {
                logger.warn((Object)("errorHint variable [" + this.errorHintVariable + "] is not defined."));
            }
        }
    }

    public void execute(ExecutionContext context) throws Exception {
        ActionException actionException = (ActionException)context.getException();
        WorkflowMessage workflowMessage = (WorkflowMessage)actionException.getProperty("message");
        if (workflowMessage != null) {
            this.setExceptionVariables(workflowMessage, context);
        } else {
            CustomToken token = (CustomToken)context.getToken();
            String node = token.getCurrentNode().getName();
            logger.error((Object)("[Process] " + token + " (" + node + "), execution has failed"), (Throwable)actionException);
            ((CustomToken)context.getToken()).fail((Throwable)actionException);
        }
    }
}

