/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.AbstractTaskNode;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.driver.event.TaskCreatedEvent;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class ManualTaskNode
extends AbstractTaskNode {
    private static final long serialVersionUID = -3253673825117496921L;
    private static final Logger logger = Logger.getLogger(ManualTaskNode.class);

    public ManualTaskNode() {
    }

    public ManualTaskNode(String name) {
        super(name);
    }

    public void execute(ExecutionContext executionContext) {
        CustomToken token = (CustomToken)executionContext.getToken();
        WorkflowProcess process = token.getProcessInstance();
        logger.info((Object)(token + " (" + this.name + ")"));
        try {
            TaskMgmtInstance tmi = process.getTaskMgmtInstance();
            Set tasklist = this.getTasks();
            if (tasklist != null) {
                Iterator iter = tasklist.iterator();
                if (iter.hasNext()) {
                    Task task = (Task)iter.next();
                    executionContext.setTask(task);
                    tmi.createTaskInstance(task, executionContext);
                }
                this.fireTaskCreatedEvent(process);
            }
            if (this.action != null) {
                this.action.execute(executionContext);
            }
        }
        catch (Throwable t) {
            try {
                this.raiseException(t, executionContext);
            }
            catch (DelegationException e) {
                logger.warn((Object)(token + ", no exception handler defined for template - " + process.getProcessDefinition().getName()));
                token.fail();
            }
        }
    }

    private void fireTaskCreatedEvent(WorkflowProcess process) {
        DefaultMediator.getInstance().send((WorkflowEvent)new TaskCreatedEvent(this, process));
    }
}

