/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.hazelcast.config.Config;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.internal.ServiceLifecycleListener;
import com.tandbergtv.workflow.core.service.preferences.IUserPreferenceManager;
import com.tandbergtv.workflow.core.service.preferences.UserPreferenceManagerFactory;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.monitor.ClusterConfiguration;
import com.tandbergtv.workflow.monitor.Observers;
import com.tandbergtv.workflow.monitor.Recorders;
import com.tandbergtv.workflow.monitor.core.IMetricProcessor;
import com.tandbergtv.workflow.monitor.core.IRecorder;
import com.tandbergtv.workflow.monitor.event.EventHandlerRegistry;
import com.tandbergtv.workflow.monitor.event.IEventHandlerRegistry;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.JMException;
import org.apache.log4j.Logger;

public class Activator {
    private static final String SCHEDULER_NAME = "recorder";
    private static final String STATS_DIR = "stats";
    private static final String FS_RECORDER = "fs-recorder";
    private static final String CLUSTER_PROPERTIES = "cluster.properties";
    private static final Logger logger = Logger.getLogger(Activator.class);

    public void start() {
        UserPreferenceManagerFactory factory = UserPreferenceManagerFactory.newInstance();
        this.addService((Service)factory.newUserPreferenceManager());
        this.addService(new EventHandlerRegistry());
        ServiceLifecycleListener listener = new ServiceLifecycleListener();
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".dependencies");
        for (String key : Collections.list(bundle.getKeys())) {
            listener.addDependencyFor(key, bundle.getString(key));
        }
        this.addService((Service)listener);
        this.joinCluster();
        this.startRecorder();
        this.addObservers();
    }

    public void stop() {
        this.removeService(IMetricProcessor.class);
        this.removeService(FS_RECORDER);
        this.removeService(ServiceLifecycleListener.class);
        this.removeService(IEventHandlerRegistry.class);
        this.leaveCluster();
        this.removeService(IUserPreferenceManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinCluster() {
        InputStream is = null;
        try {
            Properties properties = new Properties();
            File file = new File(ApplicationProperties.getInstance().getProperty("WorkflowApp.ConfigPath"), CLUSTER_PROPERTIES);
            if (file.exists()) {
                is = new FileInputStream(file);
                properties.load(is);
            }
            Config config = ClusterConfiguration.create(properties);
            Hazelcast.init((Config)config);
            Cluster cluster = Hazelcast.getCluster();
            cluster.addMembershipListener(new MembershipListener(){

                public void memberRemoved(MembershipEvent e) {
                    logger.warn((Object)e.getMember().getInetSocketAddress());
                }

                public void memberAdded(MembershipEvent e) {
                    logger.info((Object)e.getMember().getInetSocketAddress());
                }
            });
        }
        catch (IOException e1) {
            logger.warn((Object)"Cannot join cluster", (Throwable)e1);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void leaveCluster() {
        Hazelcast.getLifecycleService().shutdown();
        Hazelcast.shutdownAll();
    }

    private void startRecorder() {
        Scheduler pool = new Scheduler(SCHEDULER_NAME, 1, 1);
        String dir = System.getProperty("java.io.tmpdir");
        try {
            dir = ApplicationProperties.getInstance().getProperty("install.dir");
        }
        catch (IOException e) {
            // empty catch block
        }
        String path = dir + File.separator + STATS_DIR;
        System.setProperty("com.tandbergtv.watchpoint.statsdir", path);
        this.addService((Service)Recorders.toFileSystem((ISchedulerService)pool, (String)FS_RECORDER));
    }

    private void addObservers() {
        IRecorder recorder = (IRecorder)ServiceRegistry.getDefault().lookup(FS_RECORDER);
        this.addObserver(recorder, "java.lang:type=Threading", "ThreadCount");
        this.addObserver(recorder, "com.tandbergtv.watchpoint:type=Page,*", "EWMA");
    }

    private void addObserver(IRecorder recorder, String name, String attribute) {
        try {
            recorder.addObserver(Observers.localJMXObserver((String)name, (String)attribute));
        }
        catch (JMException e) {
            Logger.getLogger(Activator.class).warn((Object)":(", (Throwable)e);
        }
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void removeService(String name) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup(name);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }
}

