/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.driver.EventUnicast;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.event.message.MessageRejectedEvent;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConsumerKey;
import com.tandbergtv.workflow.resourcemanager.event.IResourceConsumerAware;
import com.tandbergtv.workflow.resourcemanager.event.QueueOrderChangedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAcquiredEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAllocationFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceRequestRejectedEvent;
import com.tandbergtv.workflow.resourcemanager.event.WorkflowProcessStatusLogEvent;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.Token;

public final class EngineDriver
implements IColleague {
    private static EngineDriver instance;
    private static final Logger logger;
    private static final String ALLOCATED_RESOURCE_KEY_VARIABLE = "_allocated_resource_";

    private EngineDriver() {
    }

    public static synchronized EngineDriver getInstance() {
        if (instance == null) {
            instance = new EngineDriver();
        }
        return instance;
    }

    private CustomToken getToken(ResourceConsumerKey key) {
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
        WorkflowProcess process = (WorkflowProcess)cache.get((Serializable)Long.valueOf(key.getParentId()));
        return process.findToken(key.getId());
    }

    private IProcessManagerService getProcessManagerService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    private ISchedulerService<CustomToken> getScheduler() {
        return (ISchedulerService)ServiceRegistry.getDefault().lookup("one-shot-distributed-scheduler");
    }

    private void save(WorkflowProcess process) {
        ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).save(process);
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        Object source = event.getSource();
        if (source == this) {
            return;
        }
        if (!(event instanceof IResourceConsumerAware)) {
            return;
        }
        ResourceConsumerKey key = ((IResourceConsumerAware)IResourceConsumerAware.class.cast(event)).getResourceConsumerKey();
        if (event instanceof ResourceAcquiredEvent) {
            ResourceAcquiredEvent e = (ResourceAcquiredEvent)event;
            CustomToken token = this.getToken(key);
            WorkflowProcess process = token.getProcessInstance();
            if (!this.owner(process)) {
                this.sendEvent(token, event);
                return;
            }
            if (token.getStatus() != ProcessStatus.QUEUED) {
                logger.warn((Object)(token + " spurious resource grant"));
                return;
            }
            logger.debug((Object)(token + " got resource"));
            this.sendEvent((WorkflowEvent)new WorkflowProcessStatusLogEvent(true, (Token)token, e.getResourceGroup(), e.getResource(), e.getStart(), e.getAllocationTime()));
            String name = ALLOCATED_RESOURCE_KEY_VARIABLE + token.getId();
            String value = e.getAllocatedResourceKey();
            ContextInstance c = process.getContextInstance();
            c.setTransientVariable(name, (Object)value);
            c.setTransientVariable("_resource_" + token.getId(), (Object)e.getResource());
            c.setTransientVariable("_task_assigner_" + token.getId(), (Object)e.getTaskAssigner());
            this.getProcessManagerService().dequeue(token);
        } else if (event instanceof ResourceRequestRejectedEvent) {
            CustomToken token = this.getToken(key);
            if (!this.owner(token.getProcessInstance())) {
                this.sendEvent(token, event);
                return;
            }
            if (token.getStatus() == ProcessStatus.QUEUED) {
                logger.warn((Object)(token + " - resource request was rejected"));
                token.fail(ErrorCategory.RESOURCE_REQUEST_REJECTED, "Resource request was rejected");
            } else {
                logger.warn((Object)(token + " - resource request was rejected"));
            }
        } else if (event instanceof QueueOrderChangedEvent) {
            CustomToken token = this.getToken(key);
            if (!this.owner(token.getProcessInstance())) {
                this.sendEvent(token, event);
                return;
            }
            QueueOrderChangedEvent e = (QueueOrderChangedEvent)event;
            WorkflowProcess process = token.getProcessInstance();
            ProcessPriority priority = e.getPriority();
            logger.debug((Object)(token + ", event QUEUE REORDER " + priority));
            if (process.getPriority().equals((Object)priority)) {
                return;
            }
            process.setPriority(priority);
            this.save(process);
            for (CustomToken t : process.findAllTokens()) {
                if (t.equals((Object)token)) continue;
                this.sendEvent((WorkflowEvent)new WorkflowProcessEvent(process, (Token)t, WorkflowProcessEventType.PRIORITY_CHANGED));
            }
        } else if (event instanceof ResourceFailedEvent) {
            ResourceFailedEvent e = (ResourceFailedEvent)event;
            CustomToken token = this.getToken(key);
            if (!this.owner(token.getProcessInstance())) {
                this.sendEvent(token, event);
                return;
            }
            logger.debug((Object)(token + " event RESOURCE FAILURE (" + token.getNode().getName() + ")"));
            ContextInstance c = token.getProcessInstance().getContextInstance();
            c.deleteTransientVariable("_resource_" + token.getId());
            c.deleteTransientVariable("_task_assigner_" + token.getId());
            if (e.isHeartBeatFailure()) {
                token.setResumeAfterFail(true);
            }
            token.abort();
        } else if (event instanceof ResourceAllocationFailedEvent) {
            CustomToken token = this.getToken(key);
            if (!this.owner(token.getProcessInstance())) {
                this.sendEvent(token, event);
                return;
            }
            ResourceAllocationFailedEvent e = (ResourceAllocationFailedEvent)event;
            this.sendEvent((WorkflowEvent)new MessageRejectedEvent((Object)this, (Token)token, e.getMessage()));
        }
    }

    private boolean owner(WorkflowProcess process) {
        return ProcessFinder.isOwner((WorkflowProcess)process);
    }

    private void sendEvent(WorkflowEvent event) {
        DefaultMediator.getInstance().sendAsync(event);
    }

    private void sendEvent(CustomToken token, WorkflowEvent event) {
        this.getScheduler().schedule((Callable)((Object)new EventUnicast(token, event)));
    }

    static {
        logger = Logger.getLogger(EngineDriver.class);
    }
}

