/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.ui;

import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.internal.FileRecorderProperties;
import com.tandbergtv.workflow.monitor.internal.MetricProcessor;
import java.io.File;
import java.io.IOException;
import javax.management.JMException;
import org.apache.log4j.Logger;

public abstract class AbstractImageWriter
extends MetricProcessor {
    protected File root;
    private static final Logger logger = Logger.getLogger(AbstractImageWriter.class);

    protected AbstractImageWriter(ISchedulerService<Void> pool, File root) {
        super(pool);
        this.root = root;
    }

    @Override
    public void process() {
        for (Metric metricName : this.metricNames) {
            try {
                this.writeImage(metricName);
            }
            catch (IOException e) {
                logger.warn((Object)":_(", (Throwable)e);
            }
            catch (JMException e) {
                logger.warn((Object)":(", (Throwable)e);
            }
        }
    }

    protected void writeImage(Metric metricName) throws IOException, JMException {
        File dir = this.getOutputDirectory(metricName);
        File imageFile = FileRecorderProperties.getPNGFile(dir, metricName);
        this.writeImage(imageFile, metricName);
    }

    protected File getOutputDirectory(Metric metricName) {
        File dir = new File(this.root, metricName.getType());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    protected abstract void writeImage(File var1, Metric var2);
}

