/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.monitor.Metrics;
import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.internal.FileRecorderProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

public class FileSystemReader {
    private File root;

    public FileSystemReader(File root) {
        this.root = root;
    }

    public List<Metric> read(Metric metricName, long period, TimeUnit t) {
        File dir = new File(this.root, metricName.getType());
        File file = FileRecorderProperties.getFile(dir, metricName);
        return this.read(file, metricName);
    }

    private List<Metric> read(File file, Metric metricName) {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        if (!file.exists()) {
            return metrics;
        }
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(file);
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, Charset.forName("UTF-8")));
                String line = r.readLine();
                String name = null;
                if (line != null) {
                    StringTokenizer t = new StringTokenizer(line);
                    t.nextToken();
                    name = t.nextToken();
                }
                while ((line = r.readLine()) != null) {
                    try {
                        Metric metric = this.parse(line, metricName, name);
                        metrics.add(metric);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return Collections.unmodifiableList(metrics);
    }

    private Metric parse(String line, Metric metric, String name) {
        StringTokenizer t = new StringTokenizer(line);
        long time = Long.valueOf(t.nextToken());
        String value = t.nextToken();
        return Metrics.newMetric(name, metric.getType(), metric.getDomain(), value, time);
    }
}

