/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.internal.callable.OneShotTokenCallable;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public final class StartToken
extends OneShotTokenCallable {
    private static final long serialVersionUID = -3471049028794105401L;

    public StartToken(CustomToken token) {
        super(token);
    }

    @Override
    protected Callable<CustomToken> innerCallable(final CustomToken token) {
        return new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                if (token.isRoot()) {
                    WorkflowProcess process = token.getProcessInstance();
                    process.getContextInstance().setVariable("_partition", (Object)Cluster.getPartitionId((Object)process.getId()));
                    ProcessFinder.updateOwner(process);
                }
                try {
                    if (StartToken.this.getIsHalted()) {
                        token.suspend();
                        StartToken.this.counter().paused(token);
                    } else {
                        token.start();
                        StartToken.this.counter().started(token);
                    }
                }
                catch (StackOverflowError e) {
                    StartToken.this.handleStackOverflowError(token, e);
                }
                catch (Throwable t) {
                    Logger.getLogger(StartToken.class).error((Object)token, t);
                }
                return token;
            }
        };
    }

    private boolean getIsHalted() {
        IProcessManagerService service = (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
        String haltedValue = service.getProperties().getProperty("isDriverHalted");
        return Boolean.parseBoolean(haltedValue);
    }
}

