/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import java.util.Date;

public class TokenError {
    private CustomToken token;
    private ErrorCategory category;
    private String message;
    private Date time;

    public TokenError(CustomToken token, ErrorCategory category, String message, Date time) {
        this.token = token;
        this.category = category;
        this.message = message;
        this.time = time;
    }

    public ErrorCategory getCategory() {
        return this.category;
    }

    public String getMessage() {
        if (this.category == ErrorCategory.CHILD_PROCESS_FAILED) {
            return "Subprocess ID " + this.token.getSubProcessInstance().getId() + " failed";
        }
        if (this.category == ErrorCategory.TIMEOUT) {
            return "Timed out at " + this.token.getCurrentNode().getName();
        }
        if (this.category == ErrorCategory.INFINITE_LOOP) {
            return "Loop exceeded iteration limit";
        }
        return this.message;
    }

    public Date getTime() {
        return this.time;
    }
}

