/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.XMLTemplateHandler;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import org.apache.log4j.Logger;

public class SOAPHandler
extends XMLTemplateHandler {
    private static final Logger logger = Logger.getLogger(SOAPHandler.class);
    private static final String SOAP_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body>";
    private static final String SOAP_FOOTER = "</soapenv:Body></soapenv:Envelope>";

    public SOAPHandler() {
    }

    public SOAPHandler(IHandlerConfiguration conf) throws HandlerException {
        super(conf);
    }

    @Override
    public IMessage process(IMessage message) throws HandlerException {
        logger.debug((Object)("Processing message: " + message));
        HTTPMessage xmlMessage = (HTTPMessage)super.process(message);
        HTTPPayload payload = (HTTPPayload)xmlMessage.getPayload();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SOAP_HEADER);
        stringBuilder.append(payload.getContent());
        stringBuilder.append(SOAP_FOOTER);
        payload.setContent(stringBuilder.toString());
        logger.debug((Object)("Output: " + xmlMessage));
        return xmlMessage;
    }
}

