/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.log.NodeLogs;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.entities.WorkflowNodeLog;
import com.tandbergtv.workflow.log.hibernate.WorkflowMessageLogHDAO;
import com.tandbergtv.workflow.log.hibernate.WorkflowNodeLogHDAO;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;

public class WorkflowLogManager
implements Service {
    private static final String QUERY_CLAUSE = "from jbpm_log l where l.class_ = 'N' and l.token_ in (:tokenIDs) and l.node_ in (:nodeIDs) ";
    private static final String ORDER_BY_CLAUSE = "order by l.date_ ";
    private static final String SELECT = "select l.* ";
    private static final String COUNT = "select count(*) ";
    private static final Logger logger = Logger.getLogger(WorkflowLogManager.class);
    private boolean initialized = false;
    private SessionFactory factory;

    private WorkflowLogManager() {
    }

    public WorkflowLogManager(SessionFactory factory) {
        this();
        this.factory = factory;
    }

    public String getServiceName() {
        return "Logger";
    }

    public void start() {
        if (this.initialized) {
            logger.info((Object)"Workflow Log Manager already initialized. Ignoring the initialize() call.");
            return;
        }
        logger.debug((Object)"Initializing the Workflow Log Manager...");
        this.initialized = true;
    }

    public void stop() {
        logger.debug((Object)"Destroying the Workflow Log Manager...");
        this.initialized = false;
    }

    protected SessionFactory getSessionFactory() {
        return this.factory;
    }

    protected Session getSession() {
        return this.getSessionFactory().openSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeLog> getHistoryTasks(List<CustomToken> tokens, int numRecords, int startingRecordNum) {
        ArrayList<NodeLog> jbpmNodeLogs = new ArrayList();
        Session session = this.getSession();
        try {
            SQLQuery query = session.createSQLQuery(this.buildHistoryTasksQuery(false));
            query.setParameterList("tokenIDs", this.getTokenIDList(tokens));
            query.setParameterList("nodeIDs", this.getNodeIDList(tokens));
            query.setMaxResults(numRecords);
            query.setFirstResult(startingRecordNum);
            jbpmNodeLogs = NodeLogs.from(tokens.get(0).getProcessInstance(), query.list());
        }
        finally {
            session.close();
        }
        return jbpmNodeLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryTasksCount(List<CustomToken> tokens) {
        Session session = this.getSession();
        try {
            SQLQuery query = session.createSQLQuery(this.buildHistoryTasksQuery(true));
            query.setParameterList("tokenIDs", this.getTokenIDList(tokens));
            query.setParameterList("nodeIDs", this.getNodeIDList(tokens));
            int n = ((Number)query.uniqueResult()).intValue();
            return n;
        }
        finally {
            session.close();
        }
    }

    private String buildHistoryTasksQuery(boolean count) {
        StringBuffer query = null;
        query = count ? new StringBuffer(COUNT) : new StringBuffer(SELECT);
        query.append(QUERY_CLAUSE);
        if (!count) {
            query.append(ORDER_BY_CLAUSE);
        }
        return query.toString();
    }

    private List<Long> getTokenIDList(List<CustomToken> tokens) {
        ArrayList<Long> tokenIDList = new ArrayList<Long>();
        for (CustomToken token : tokens) {
            tokenIDList.add(token.getId());
        }
        return tokenIDList;
    }

    private List<Long> getNodeIDList(List<CustomToken> tokens) {
        final ArrayList<Long> nodes = new ArrayList<Long>();
        WorkflowTemplate template = tokens.get(0).getProcessInstance().getProcessDefinition();
        template.breadthFirstTraversal(new NodeVisitor(){

            public void visit(Node node) {
                nodes.add(node.getId());
            }
        });
        return nodes;
    }

    public List<WorkflowMessageLog> getHistoryTaskMessages(long historyTaskMessagesKey, int numRecords, int startingRecordNum, String sortColumn, SortingOrder sortOrder) {
        WorkflowMessageLogHDAO messageLogDAO = new WorkflowMessageLogHDAO(this.getSession());
        return messageLogDAO.findByJBPMNodeLogID(historyTaskMessagesKey, numRecords, startingRecordNum, sortColumn, sortOrder);
    }

    public int getHistoryTaskMessagesCount(long historyTaskMessagesKey) {
        WorkflowMessageLogHDAO messageLogDAO = new WorkflowMessageLogHDAO(this.getSession());
        return messageLogDAO.countByJBPMNodeLogID(historyTaskMessagesKey);
    }

    public List<WorkflowMessageLog> getCurrentTaskMessages(long currentTaskMessagesKey, int numRecords, int startingRecordNum, String sortColumn, SortingOrder sortOrder) {
        WorkflowMessageLogHDAO messageLogDAO = new WorkflowMessageLogHDAO(this.getSession());
        return messageLogDAO.findByWorkflowNodeLogID(currentTaskMessagesKey, numRecords, startingRecordNum, sortColumn, sortOrder);
    }

    public int getCurrentTaskMessagesCount(long currentTaskMessagesKey) {
        WorkflowMessageLogHDAO messageLogDAO = new WorkflowMessageLogHDAO(this.getSession());
        return messageLogDAO.countByWorkflowNodeLogID(currentTaskMessagesKey);
    }

    public long getCurrentTaskMessagesKey(Token token, Node node) {
        WorkflowNodeLogHDAO wfsNodeLogDAO = new WorkflowNodeLogHDAO(this.getSession());
        WorkflowNodeLog workflowNodeLog = wfsNodeLogDAO.findCurrentByTokenAndNode(token, node);
        return workflowNodeLog != null ? workflowNodeLog.getId() : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryTaskIteration(long historyTaskID) {
        Session session = this.getSession();
        try {
            String queryString = "select count(*) from NodeLog n where n.node.id = (select n1.node.id from NodeLog n1 where n1.id = " + historyTaskID + ") and n.token.processInstance = (select n2.token.processInstance from NodeLog n2 where n2.id = " + historyTaskID + ") and n.id <= " + historyTaskID;
            Query query = session.createQuery(queryString);
            int n = ((Long)query.uniqueResult()).intValue();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to get iteration number of history task | historyTaskID: " + historyTaskID), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryTaskNumIterations(long historyTaskID) {
        Session session = this.getSession();
        try {
            String queryString = "select count(wnl) from WorkflowNodeLog wnl, NodeLog nl where wnl.node = nl.node and wnl.token.processInstance = nl.token.processInstance and nl.id = " + historyTaskID;
            Query query = session.createQuery(queryString);
            int n = ((Long)query.uniqueResult()).intValue();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to get total # iterations of history task | historyTaskID: " + historyTaskID), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            session.close();
        }
    }
}

