/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.event;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import java.util.Date;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;

public class WorkflowMessageLogEvent
extends WorkflowEvent {
    private static final long serialVersionUID = 7124297272341516058L;
    private Node node;
    private Token token;
    private boolean incoming;
    private Resource resource;
    private WorkflowMessage wfsMessage;
    private Date timestamp;

    public WorkflowMessageLogEvent(Token token, Node node, boolean incoming, WorkflowMessage wfsMessage) {
        this(token, node, incoming, null, wfsMessage);
    }

    public WorkflowMessageLogEvent(Token token, Node node, boolean incoming, Resource resource, WorkflowMessage wfsMessage) {
        this.token = token;
        this.node = node;
        this.incoming = incoming;
        if (resource != null && resource.getId() != -1L) {
            this.resource = new Resource(resource.getId());
        }
        this.wfsMessage = wfsMessage;
        this.timestamp = new Date();
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public Node getNode() {
        return this.node;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Token getToken() {
        return this.token;
    }

    public boolean isTrace() {
        WorkflowProcess process = ((CustomToken)CustomToken.class.cast(this.token)).getProcessInstance();
        return process.getLogLevel().compareTo((Enum)LogLevel.OFF) > 0;
    }

    public WorkflowMessage getWfsMessage() {
        return this.wfsMessage;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        String str = "[ Node: " + this.node + " | Token: " + this.token + " | Incoming: " + this.incoming + " | Resource: " + this.resource + " | Timestamp: " + this.timestamp + " | WFSMessage: " + this.wfsMessage + " ]";
        return str;
    }
}

