/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.boot.clusteredservices;

import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.log.LogSyncService;
import com.tandbergtv.workflow.log.LogZipService;
import com.tandbergtv.workflow.log.WorkflowLogManager;
import com.tandbergtv.workflow.log.WorkflowLogService;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.File;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class HistoryLoggingListener
implements MembershipListener {
    private static final Logger logger = Logger.getLogger(HistoryLoggingListener.class);
    private static final Long ONE_HOUR = 3600L;
    private static final Long ONE_DAY = 24L * ONE_HOUR;
    private final Lock mutex = new ReentrantLock();
    private boolean servicesStarted;
    private Properties properties = null;
    private WorkflowLogService wfLogService = null;

    public HistoryLoggingListener(Properties properties) {
        this.properties = properties;
        try {
            String dir = this.setupHistoryDirectory();
            SessionFactory factory = HibernateUtil.getSessionFactory();
            Long archivingPeriod = this.getProperty(this.properties, "history.archiving.period", 6L * ONE_HOUR);
            Long retentionWindow = this.getProperty(this.properties, "history.retention.period", 30L * ONE_DAY);
            this.wfLogService = new WorkflowLogService(factory, dir, archivingPeriod, retentionWindow);
            this.addService(this.wfLogService);
            this.addService(new WorkflowLogManager(factory));
        }
        catch (Exception e) {
            logger.error((Object)"Exception encountered while attempting to start WofkflowLogService", (Throwable)e);
        }
    }

    private String setupHistoryDirectory() {
        String dir = this.getHistoryDirectory();
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
        return dir;
    }

    public void memberAdded(MembershipEvent evt) {
        logger.debug((Object)("Member [" + evt.getMember().getInetSocketAddress() + "] was added"));
    }

    public void memberRemoved(MembershipEvent evt) {
        logger.debug((Object)("Member [" + evt.getMember().getInetSocketAddress() + "] was removed"));
        this.startServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServices() {
        logger.debug((Object)"Analyzing if services need to be started at this node");
        if (this.servicesStarted) {
            logger.debug((Object)"Services are already started at this node");
            return;
        }
        if (!Cluster.isMaster()) {
            logger.debug((Object)"Service will not be started at this node since this is not the master");
            return;
        }
        logger.debug((Object)"Attempting to start the services");
        try {
            SessionFactory factory = HibernateUtil.getSessionFactory();
            this.mutex.lock();
            if (!this.servicesStarted) {
                this.setupHistoryLogging(this.properties, factory);
                this.servicesStarted = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception encountered while attempting to start History Loggine Services", (Throwable)e);
        }
        finally {
            this.mutex.unlock();
        }
    }

    private void setupHistoryLogging(Properties props, SessionFactory factory) {
        logger.debug((Object)"Setting up History Logging Services");
        String dir = this.getHistoryDirectory();
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
        this.wfLogService.startGCOnMaster();
        Long syncPeriod = this.getProperty(props, "history.sync.period", ONE_HOUR);
        this.addService(new LogSyncService(factory, dir, syncPeriod));
        Long compressPeriod = this.getProperty(props, "history.compress.period", ONE_HOUR);
        this.addService(new LogZipService(factory, dir, compressPeriod));
        logger.debug((Object)"Done setting up History Logging Services");
    }

    private String getHistoryDirectory() {
        try {
            return ApplicationProperties.getInstance().getProperty("install.dir") + "/history/process/";
        }
        catch (InvalidPropertiesFormatException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private long getProperty(Properties props, String name, long value) {
        return Long.valueOf(props.getProperty(name, String.valueOf(value)));
    }
}

