/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.tandbergtv.workflow.core.queue.AbstractQueue;
import com.tandbergtv.workflow.core.queue.IQueueInsertStrategy;
import com.tandbergtv.workflow.core.queue.QueueException;
import com.tandbergtv.workflow.core.queue.QueueItem;
import com.tandbergtv.workflow.driver.message.queue.MessageOffloadQueue;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.io.File;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

final class InsertStrategy<T>
implements IQueueInsertStrategy<WorkflowMessage> {
    private MessageOffloadQueue<WorkflowMessage> queue;
    private String dir;
    private static final Logger logger = Logger.getLogger(InsertStrategy.class);

    public InsertStrategy(MessageOffloadQueue<WorkflowMessage> queue) {
        this.queue = queue;
        this.dir = queue.getQueueDir();
    }

    public AbstractQueue<WorkflowMessage> getQueue() {
        return this.queue;
    }

    public void insert(QueueItem<WorkflowMessage> item) {
        WorkflowMessage message = (WorkflowMessage)item.getItem();
        try {
            String filename = this.dir + File.separator + System.currentTimeMillis() + "-" + UUID.randomUUID() + ".xml";
            Document document = Marshaller.newMarshaller().marshal(message);
            logger.debug((Object)("Writing message [" + message.getMessageUID() + "] to " + filename));
            XMLDocumentUtility.save(document, filename);
        }
        catch (Exception e) {
            throw new QueueException("Failed to save message [" + message.getMessageUID() + "]", (Throwable)e);
        }
    }
}

