/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.task.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.driver.task.ITaskAssignmentValidationService;
import com.tandbergtv.workflow.driver.task.ITaskAssignmentValidator;
import com.tandbergtv.workflow.driver.task.TaskAssignmentValidationException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public class TaskAssignmentValidationService
implements ITaskAssignmentValidationService {
    private static final Logger logger = Logger.getLogger(TaskAssignmentValidationService.class);
    private static final String UI_PLUGIN = "com.tandbergtv.workflow.ui";
    private static final String EXTENSION_POINT = "taskAssignmentValidator";

    public String getServiceName() {
        return "task-assignment-validation-service";
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public void validateTaskAssignee(String userName, Collection<CustomToken> tokens) throws TaskAssignmentValidationException {
        if (userName == null || userName.trim().isEmpty()) {
            throw new IllegalArgumentException("The user name cannot be blank.");
        }
        Collection<ITaskAssignmentValidator> validators = this.getValidators();
        for (ITaskAssignmentValidator validator : validators) {
            validator.validateTaskAssignee(userName, tokens);
        }
    }

    @Override
    public void validateTaskAssigner(String userName, Collection<CustomToken> tokens) throws TaskAssignmentValidationException {
        if (userName == null || userName.trim().isEmpty()) {
            throw new IllegalArgumentException("The user name cannot be blank.");
        }
        Collection<ITaskAssignmentValidator> validators = this.getValidators();
        for (ITaskAssignmentValidator validator : validators) {
            validator.validateTaskAssigner(userName, tokens);
        }
    }

    private Collection<ITaskAssignmentValidator> getValidators() {
        ArrayList<ITaskAssignmentValidator> validators = new ArrayList<ITaskAssignmentValidator>();
        PluginManager pluginManager = Platform.getPlatform().getPluginManager();
        PluginRegistry registry = pluginManager.getRegistry();
        try {
            pluginManager.getPlugin(UI_PLUGIN);
            ExtensionPoint extensionPoint = registry.getExtensionPoint(UI_PLUGIN, EXTENSION_POINT);
            for (Extension extension : extensionPoint.getAvailableExtensions()) {
                try {
                    validators.add(this.getValidator(pluginManager, extension));
                }
                catch (Exception e) {
                    logger.warn((Object)("Cannot load " + ITaskAssignmentValidator.class.getName() + " implemenation from plugin " + extension.getDeclaringPluginDescriptor().getId()), (Throwable)e);
                }
            }
        }
        catch (PluginLifecycleException e) {
            logger.warn((Object)e);
        }
        return validators;
    }

    private ITaskAssignmentValidator getValidator(PluginManager manager, Extension extension) throws Exception {
        PluginDescriptor plugin = extension.getDeclaringPluginDescriptor();
        PluginClassLoader loader = manager.getPluginClassLoader(plugin);
        Class<?> clazz = loader.loadClass(extension.getParameter("class").valueAsString());
        return (ITaskAssignmentValidator)clazz.newInstance();
    }
}

