/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.hazelcast.config.Config;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClusterConfiguration {
    private static final String INITIAL_WAIT = "initial.wait";
    private static final String HOST_IP = "host.ip";
    private static final String CLUSTER_PASSWORD = "cluster.password";
    private static final String CLUSTER_NAME = "cluster.name";
    private static final String MULTICAST_PORT = "multicast.port";
    private static final String MULTICAST_IP = "multicast.ip";
    private static final Logger logger = Logger.getLogger(ClusterConfiguration.class);

    public static Config create(Properties properties) throws IOException {
        String wait;
        String password;
        String port;
        System.setProperty("hazelcast.logging.type", "log4j");
        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
        String ip = properties.getProperty(MULTICAST_IP);
        if (ip != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastGroup(ip);
            logger.info((Object)("Cluster multicast IP " + ip));
        }
        if ((port = properties.getProperty(MULTICAST_PORT)) != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(Integer.parseInt(port));
            logger.info((Object)("Cluster multicast port " + port));
        }
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(false);
        config.getNetworkConfig().getInterfaces().clear();
        String host = properties.getProperty(HOST_IP);
        if (host == null) {
            host = ClusterConfiguration.getAddress().getHostAddress();
        }
        logger.debug((Object)("Cluster host " + host));
        config.getNetworkConfig().getInterfaces().addInterface(host);
        config.getNetworkConfig().getInterfaces().setEnabled(true);
        String name = properties.getProperty(CLUSTER_NAME);
        if (name != null) {
            logger.debug((Object)("Cluster name " + name));
            config.getGroupConfig().setName(name);
        }
        if ((password = properties.getProperty(CLUSTER_PASSWORD)) != null) {
            config.getGroupConfig().setPassword(password);
        }
        if ((wait = properties.getProperty(INITIAL_WAIT)) != null) {
            config.setProperty("hazelcast.initial.wait.seconds", wait);
        }
        return config;
    }

    private static InetAddress getAddress() throws IOException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface ni = interfaces.nextElement();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                return address;
            }
        }
        return InetAddress.getLocalHost();
    }
}

