/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util.watch;

import com.tandbergtv.watchpoint.watchfolder.core.WatchFolderManager;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WatchFolderService
implements Service {
    private static final String PACKAGE_NAME = "com/tandbergtv/workflow/util/watch/";
    private static final String WATCHFOLDER_XML = "watchfolder.xml";

    public void start() {
        try {
            WatchFolderManager monitor = WatchFolderManager.getInstance();
            ApplicationProperties properties = ApplicationProperties.getInstance();
            File file = new File(properties.getProperty("WorkflowApp.ConfigPath"), WATCHFOLDER_XML);
            if (!file.exists()) {
                File dir = new File(System.getProperty("java.io.tmpdir"));
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                file = new File(dir, WATCHFOLDER_XML);
                this.write(file, "com/tandbergtv/workflow/util/watch/watchfolder.xml");
            }
            monitor.setConfiguration(file.getAbsolutePath());
            monitor.initialize();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start watchfolder monitoring", e);
        }
    }

    public void stop() {
        WatchFolderManager.getInstance().shutdown();
    }

    public String getServiceName() {
        return "watchfolder-service";
    }

    void write(File file, String resource) {
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(resource);
            fos = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            int read = 0;
            while ((read = is.read(buf)) > 0) {
                fos.write(buf, 0, read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

