/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.driver.event.ProcessLogEvent;
import com.tandbergtv.workflow.log.EventSerializer;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.resourcemanager.event.WorkflowProcessStatusLogEvent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class LogEventListener
implements IColleague {
    private EventSerializer serializer;
    private ExecutorService eventProcessor;

    public LogEventListener(EventSerializer serializer) {
        this.serializer = serializer;
        this.eventProcessor = Executors.newFixedThreadPool(5, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("Log Event Listener");
                t.setDaemon(true);
                return t;
            }
        });
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(final WorkflowEvent event) {
        this.eventProcessor.execute(new Runnable(){

            @Override
            public void run() {
                if (event instanceof WorkflowMessageLogEvent) {
                    LogEventListener.this.serializer.serialize((WorkflowMessageLogEvent)event);
                } else if (event instanceof WorkflowProcessStatusLogEvent) {
                    LogEventListener.this.serializer.serialize((WorkflowProcessStatusLogEvent)event);
                } else if (event instanceof ProcessLogEvent) {
                    LogEventListener.this.serializer.serialize((ProcessLogEvent)event);
                }
            }
        });
    }
}

