/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.email;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.preferences.IUserPreferenceManager;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.exe.email.AbstractTaskNotificationHandler;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;

public class QueuedTaskNotificationHandler
extends AbstractTaskNotificationHandler
implements ActionHandler {
    private static final long serialVersionUID = 4953463511357525626L;
    private static final Logger logger = Logger.getLogger(QueuedTaskNotificationHandler.class);
    private ThreadLocal<ResourceGroup> resourceGroup = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        this.setResourceGroup(executionContext);
        try {
            if (!this.getResourceGroup().isInternallyAcquired()) {
                super.execute(executionContext);
            }
        }
        finally {
            this.clearResourceGroup();
        }
    }

    @Override
    protected List<Address> getRecipients(ExecutionContext context) {
        ArrayList<Address> recipients = new ArrayList<Address>();
        ResourceGroup group = this.getResourceGroup();
        for (Resource resource : group.getResources()) {
            try {
                if (!this.isNotificationRequired(resource.getUserName())) continue;
                recipients.add((Address)new InternetAddress(resource.getConnectionString()));
            }
            catch (AddressException e) {
                logger.warn((Object)("Cannot send queued task email notification to resource" + resource + ", email address: " + resource.getConnectionString() + " is invalid."), (Throwable)e);
            }
        }
        return recipients;
    }

    private boolean isNotificationRequired(String userName) {
        try {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IUserPreferenceManager manager = (IUserPreferenceManager)registry.lookup(IUserPreferenceManager.class);
            String value = manager.getUserPreference(userName, "sendQueuedTaskNotification");
            if (value != null && !value.trim().isEmpty()) {
                return Boolean.parseBoolean(value.trim());
            }
            return true;
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    @Override
    protected String getSubject(ExecutionContext context) {
        String subject = this.getBundle().getString("mail.queuedTask.subject");
        return MessageFormat.format(subject, this.getResourceGroup().getName());
    }

    @Override
    protected String getBodyMessage(ExecutionContext context) {
        String subject = this.getBundle().getString("mail.queuedTask.body");
        return MessageFormat.format(subject, this.getResourceGroup().getName());
    }

    @Override
    protected String getTaskURL(ExecutionContext context) {
        String pattern = null;
        try {
            pattern = ApplicationProperties.getInstance().getProperty("UserTasks.URL") + this.getBundle().getString("mail.queuedTask.url");
        }
        catch (Exception e) {
            throw new ActionException("Failed to read application property[UserTasks.URL].", (Throwable)e);
        }
        String resourceGroupId = Long.toString(this.getResourceGroup().getId());
        return MessageFormat.format(pattern, resourceGroupId);
    }

    @Override
    protected String getProcessTaskDetails(ExecutionContext context) {
        StringBuilder details = new StringBuilder(super.getProcessTaskDetails(context));
        details.append(System.getProperty("line.separator"));
        String groupPattern = this.getBundle().getString("mail.queuedTask.details.groupName");
        String groupName = this.getResourceGroup().getName();
        details.append(MessageFormat.format(groupPattern, groupName));
        return details.toString();
    }

    @Override
    protected String getBodySignature(ExecutionContext context) {
        return null;
    }

    private void setResourceGroup(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        Node node = token.getCurrentNode();
        String nodeName = node.getName() + " [" + node.getProcessDefinition().getName() + "]";
        if (!(node instanceof ResourceGroupAware)) {
            String msg = "Cannot send queued task notification for node: " + nodeName + ", no resource group associated with the node.";
            throw new ActionException(msg);
        }
        Long resourceGroupId = null;
        ResourceGroup group = null;
        try {
            resourceGroupId = ((ResourceGroupAware)node).getResourceGroupID();
            ResourceManagement service = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
            group = service.getResourceGroup(resourceGroupId.longValue());
        }
        catch (Exception e) {
            String msg = "Cannot send queued task notification for node: " + nodeName + ", cannot find associated resource group[" + resourceGroupId + "].";
            throw new ActionException(msg, (Throwable)e);
        }
        if (!"04".equals(group.getResourceType().getSystemId())) {
            String msg = "Cannot send queued task notification for node: " + nodeName + ", associated resource group[" + resourceGroupId + "] is not of human type.";
            throw new ActionException(msg);
        }
        this.resourceGroup.set(group);
    }

    private void clearResourceGroup() {
        this.resourceGroup.remove();
    }

    private ResourceGroup getResourceGroup() {
        return this.resourceGroup.get();
    }
}

