/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.command.BaseTokenCommand;
import com.tandbergtv.workflow.driver.command.locate.TokenLocatorException;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.Serializable;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class RestartCommand
extends BaseTokenCommand {
    private static final long serialVersionUID = 5421165182499573659L;
    private static final Logger logger = Logger.getLogger(RestartCommand.class);

    public RestartCommand(WorkflowMessage message) {
        super(message);
    }

    @Override
    protected WorkflowMessage executeImpl(Token token) {
        WorkflowMessage ack = this.createSuccessResponse();
        long pid = token.getProcessInstance().getId();
        try {
            IPersistenceService service = (IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class);
            IProcessManagerService manager = (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
            WorkflowProcess process = service.get((Serializable)Long.valueOf(pid));
            Future f = manager.restart(process);
            ack.getPayload().putValue("NewRequestKey", Long.toString(((CustomToken)f.get()).getId()));
        }
        catch (Exception e) {
            return this.createErrorResponse(e.getMessage());
        }
        return ack;
    }

    @Override
    public WorkflowMessage execute() {
        try {
            return this.executeImpl(this.getToken());
        }
        catch (TokenLocatorException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.logMessage(this.message);
            return this.createErrorResponse(e.getMessage());
        }
    }

    @Override
    protected Token getToken() throws TokenLocatorException {
        long tokenId = Long.parseLong(this.message.getKey().toString());
        CustomToken token = ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).getToken((Serializable)Long.valueOf(tokenId));
        if (token == null) {
            throw new TokenLocatorException("Invalid request key " + tokenId);
        }
        if (!token.isRoot()) {
            token = token.getProcessInstance().getRootToken();
        }
        if (!token.getProcessInstance().getCanBeRestarted()) {
            throw new TokenLocatorException("Restart from status " + token.getStatus() + " is not allowed");
        }
        return token;
    }
}

