/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.email;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.preferences.IUserPreferenceManager;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.exe.email.AbstractTaskNotificationHandler;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class TaskNotificationHandler
extends AbstractTaskNotificationHandler
implements ActionHandler {
    private static final long serialVersionUID = 808303070540099586L;
    private static final Logger logger = Logger.getLogger(TaskNotificationHandler.class);

    @Override
    public void execute(ExecutionContext ec) throws Exception {
        Resource resource = this.getResource(ec);
        if (resource.getResourceType().getConnectionType() != ResourceConnectionType.EMAIL) {
            throw new ActionException("Resource [" + resource.getId() + "] does not have an email address");
        }
        WorkflowProcess process = (WorkflowProcess)ec.getProcessInstance();
        String id = String.valueOf(process.getId());
        logger.info((Object)("[" + id + "] got resource [" + resource.getId() + "] " + resource.getName() + " (" + resource.getConnectionString() + ")"));
        super.execute(ec);
    }

    private Long getCurrentTaskInstanceId(ExecutionContext ec) {
        Long taskId = null;
        WorkflowProcess process = (WorkflowProcess)ec.getProcessInstance();
        TaskMgmtInstance tmi = process.getTaskMgmtInstance();
        ArrayList tasks = new ArrayList();
        for (CustomToken token : process.findAllTokens()) {
            tasks.addAll(tmi.getUnfinishedTasks((Token)token));
        }
        for (TaskInstance task : tasks) {
            if (!task.getTask().getTaskNode().equals((Object)ec.getNode()) || task.hasEnded()) continue;
            taskId = task.getId();
            break;
        }
        if (taskId == null) {
            throw new ActionException(process + " does not have a valid manual task");
        }
        return taskId;
    }

    protected Resource getResource(ExecutionContext context) {
        ContextInstance c = context.getProcessInstance().getContextInstance();
        Resource resource = (Resource)c.getTransientVariable("_resource_" + context.getToken().getId());
        if (resource == null) {
            throw new ActionException(context.getToken() + ", resource unavailable");
        }
        return resource;
    }

    @Override
    protected List<Address> getRecipients(ExecutionContext context) {
        ArrayList<Address> recipients = new ArrayList<Address>();
        Resource resource = this.getResource(context);
        if (this.isNotificationRequired(resource.getUserName(), context)) {
            try {
                recipients.add((Address)new InternetAddress(resource.getConnectionString()));
            }
            catch (AddressException e) {
                throw new ActionException("User " + resource.getUserName() + " has invalid email address: " + resource.getConnectionString(), (Throwable)e);
            }
        }
        return recipients;
    }

    private boolean isNotificationRequired(String userName, ExecutionContext context) {
        String variableName;
        ContextInstance c = context.getProcessInstance().getContextInstance();
        String taskAssigner = (String)c.getTransientVariable(variableName = "_task_assigner_" + context.getToken().getId());
        if (userName.equals(taskAssigner)) {
            return false;
        }
        try {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IUserPreferenceManager manager = (IUserPreferenceManager)registry.lookup(IUserPreferenceManager.class);
            String value = manager.getUserPreference(userName, "sendAssignedTaskNotification");
            if (value != null && !value.trim().isEmpty()) {
                return Boolean.parseBoolean(value.trim());
            }
        }
        catch (RuntimeException e) {
            return true;
        }
        return true;
    }

    @Override
    protected String getSubject(ExecutionContext context) {
        return this.getBundle().getString("mail.subject");
    }

    @Override
    protected String getBodyMessage(ExecutionContext context) {
        return this.getBundle().getString("mail.body");
    }

    @Override
    protected String getTaskURL(ExecutionContext context) {
        String pattern = null;
        try {
            pattern = ApplicationProperties.getInstance().getProperty("UserTasks.URL") + this.getBundle().getString("mail.task.url");
        }
        catch (Exception e) {
            throw new ActionException("Failed to read application property[UserTasks.URL].", (Throwable)e);
        }
        String id = String.valueOf(context.getProcessInstance().getId());
        String taskId = String.valueOf(this.getCurrentTaskInstanceId(context));
        return MessageFormat.format(pattern, id, taskId);
    }

    @Override
    protected String getBodySignature(ExecutionContext context) {
        return null;
    }
}

