/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;

public class NodeLogs {
    public static List<NodeLog> from(WorkflowProcess process, List<?> resultset) {
        ArrayList<NodeLog> list = new ArrayList<NodeLog>();
        if (resultset == null || resultset.isEmpty()) {
            return list;
        }
        for (Object obj : resultset) {
            list.add(NodeLogs.fromRow(process, (Object[])obj));
        }
        return list;
    }

    private static NodeLog fromRow(WorkflowProcess process, Object[] row) {
        Long id = NodeLogs.longValue(row[0]);
        CustomToken token = process.findToken(NodeLogs.longValue(row[4]));
        Node node = NodeLogs.findNode(process.getProcessDefinition(), NodeLogs.longValue(row[9]));
        return NodeLogs.createNodeLog(id, (Date)row[3], (Token)token, node, (Date)row[10], (Date)row[11]);
    }

    private static Node findNode(WorkflowTemplate template, Long id) {
        NodeFinder finder = new NodeFinder();
        finder.id = id;
        template.breadthFirstTraversal((NodeVisitor)finder);
        return finder.target;
    }

    private static NodeLog createNodeLog(Long id, Date date, Token token, Node node, Date enter, Date leave) {
        NodeLog nodelog = new NodeLog(node, enter, leave);
        try {
            Field field = NodeLog.class.getSuperclass().getDeclaredField("id");
            field.setAccessible(true);
            field.set(nodelog, id);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        nodelog.setToken(token);
        nodelog.setDate(date);
        return nodelog;
    }

    private static long longValue(Object obj) {
        return ((Number)obj).longValue();
    }

    static class NodeFinder
    implements NodeVisitor {
        Long id;
        Node target = null;

        NodeFinder() {
        }

        public void visit(Node node) {
            if (node.getId() == this.id.longValue()) {
                this.target = node;
            }
        }
    }
}

