/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.sysmonui.corba;

import com.n2bb.util.N2bbException;
import com.n2bb.util.OrbManager;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;
import org.jacorb.orb.ParsedIOR;
import org.omg.CORBA.Object;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.ETF.Profile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CORBAManager {
    private static final org.apache.log4j.Logger n2bbLog = org.apache.log4j.Logger.getLogger(CORBAManager.class);
    final Hashtable<String, String> m_contexts = new Hashtable();
    private final TransformerFactory factory = TransformerFactory.newInstance();

    private String getAddress(Object obj) {
        n2bbLog.debug((java.lang.Object)"enter (JacORB)");
        try {
            String objStr = OrbManager.getInstance().getORB().object_to_string(obj);
            ParsedIOR pior = new ParsedIOR(objStr, OrbManager.getInstance().getORB(), (Logger)new NullLogger());
            String profile = ((Profile)pior.getProfiles().iterator().next()).toString();
            String[] address = profile.split(":");
            return InetAddress.getByName(address[0]).getHostAddress() + ':' + address[1];
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)("failed to retrieve ip and port - message... " + e.getMessage()), (Throwable)e);
            return "could not resolve";
        }
    }

    public Source getContextXML() throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            this.m_contexts.clear();
            Document document = null;
            Element root = null;
            n2bbLog.debug((java.lang.Object)"setting up DOM tree");
            try {
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
                document = domBuilder.newDocument();
                root = document.createElement("NameService");
                root.appendChild(document.createTextNode("\n"));
                document.appendChild(root);
            }
            catch (ParserConfigurationException e) {
                throw new N2bbException("error.parser.initParser", e);
            }
            catch (Exception e) {
                throw new N2bbException("error.parser.initParser", e);
            }
            try {
                this.list(OrbManager.getInstance().getNamingContextExt(), root, document);
            }
            catch (N2bbException e) {
                throw e;
            }
            catch (Exception e) {
                throw new N2bbException("error.corbaManager.buildBindingList", e);
            }
            if (n2bbLog.isDebugEnabled()) {
                this.printXML(document);
            }
            DOMSource domSource = new DOMSource(document);
            n2bbLog.debug((java.lang.Object)("domSource created... " + domSource));
            DOMSource source = domSource;
            n2bbLog.debug((java.lang.Object)("source created... " + source));
            return source;
        }
        catch (N2bbException e) {
            throw e;
        }
        catch (Exception e) {
            throw new N2bbException("error.other", e);
        }
    }

    private void mark(NamingContextExt nc) {
        this.m_contexts.put(OrbManager.getInstance().getORB().object_to_string((Object)nc), "");
    }

    private boolean isMarked(NamingContextExt nc) {
        return this.m_contexts.containsKey(OrbManager.getInstance().getORB().object_to_string((Object)nc));
    }

    private void list(NamingContextExt nameCxt, Node parent, Document document) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            if (this.isMarked(nameCxt)) {
                return;
            }
            this.mark(nameCxt);
            BindingListHolder blsoh = new BindingListHolder(new Binding[0]);
            BindingIteratorHolder bioh = new BindingIteratorHolder();
            BindingHolder bh = new BindingHolder();
            try {
                nameCxt.list(0, blsoh, bioh);
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)("failed to list bindings - message... " + e.getMessage()), (Throwable)e);
                return;
            }
            if (bioh.value == null) {
                return;
            }
            while (bioh.value.next_one(bh)) {
                Element nName;
                Element node;
                String stringName = null;
                try {
                    stringName = OrbManager.getInstance().getNamingContextExt().to_string(bh.value.binding_name);
                }
                catch (Exception e) {
                    n2bbLog.error((java.lang.Object)("failed to retreive the name of a binding - message... " + e.getMessage()), (Throwable)e);
                    n2bbLog.error((java.lang.Object)"  skipping this binding");
                    continue;
                }
                parent.appendChild(document.createTextNode("\n"));
                if (bh.value.binding_type.value() == 1) {
                    node = document.createElement("Context");
                    node.appendChild(document.createTextNode("\n"));
                    nName = document.createElement("Name");
                    nName.appendChild(document.createTextNode(stringName));
                    node.appendChild(nName);
                    parent.appendChild(node);
                    NamingContextExt subCxt = null;
                    try {
                        NameComponent[] name = OrbManager.getInstance().getNamingContextExt().to_name(stringName);
                        subCxt = NamingContextExtHelper.narrow((Object)nameCxt.resolve(name));
                    }
                    catch (Exception e) {
                        n2bbLog.error((java.lang.Object)("failed to retreive a binding by name - message... " + e.getMessage()), (Throwable)e);
                        n2bbLog.error((java.lang.Object)("  skipping this binding... " + stringName));
                        continue;
                    }
                    try {
                        this.list(subCxt, node, document);
                    }
                    catch (Exception e) {
                        n2bbLog.error((java.lang.Object)("failed to build sub binding list for this binding - message... " + e.getMessage()), (Throwable)e);
                        n2bbLog.error((java.lang.Object)("  skipping the sub bindings of this binding... " + stringName));
                    }
                    continue;
                }
                node = document.createElement("Object");
                node.appendChild(document.createTextNode("\n"));
                nName = document.createElement("Name");
                nName.appendChild(document.createTextNode(stringName));
                node.appendChild(nName);
                Element nStatus = document.createElement("Status");
                Element nAddress = document.createElement("IPAddress");
                try {
                    Object obj = nameCxt.resolve_str(stringName);
                    n2bbLog.debug((java.lang.Object)("object name resolved... " + stringName));
                    if (obj._non_existent()) {
                        nStatus.appendChild(document.createTextNode("down"));
                        n2bbLog.debug((java.lang.Object)("  " + stringName + " is down"));
                    } else {
                        nStatus.appendChild(document.createTextNode("up"));
                        n2bbLog.debug((java.lang.Object)("  " + stringName + " is up"));
                    }
                    nAddress.appendChild(document.createTextNode(this.getAddress(obj)));
                }
                catch (Exception e) {
                    nStatus.appendChild(document.createTextNode("down"));
                    n2bbLog.error((java.lang.Object)("failed to resolve object - message... " + e.getMessage()), (Throwable)e);
                    n2bbLog.error((java.lang.Object)("  object name... " + stringName));
                }
                node.appendChild(nStatus);
                node.appendChild(nAddress);
                parent.appendChild(node);
            }
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
        }
    }

    private void printXML(Document doc) {
        try {
            File file = new File("nameService.xml");
            FileOutputStream outFile = new FileOutputStream(file);
            DataOutputStream datOut = new DataOutputStream(outFile);
            PrintStream psOut = new PrintStream(datOut);
            Document node = doc;
            this.printDOMTree(node, psOut);
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
        }
    }

    private void printDOMTree(Node node, PrintStream psOut) {
        try {
            Transformer transformer = this.factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(node), new StreamResult(psOut));
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
        }
    }
}

