/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import com.tandbergtv.workflow.util.URLConfigReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ApplicationProperties
extends Properties {
    private static final long serialVersionUID = -2440412148987996833L;
    private static final Logger logger = Logger.getLogger(ApplicationProperties.class);
    private static final String PROPERTIES_FILE_PATH = "/application.properties";
    private static final String URL_CONFIG_FILENAME = "url-config.xml";
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String WORKFLOW_FOLDER_NAME = "workflow";
    private static final String LIB_DIR = "lib";
    private static final String CONF_DIR = "conf";
    private static final String PACKAGE_NAME = "com/tandbergtv/workflow/util/watch/";
    private static ApplicationProperties m_Instance;

    private ApplicationProperties() throws InvalidPropertiesFormatException, IOException {
        try {
            this.loadProperties();
        }
        catch (IOException e) {
            if (e instanceof UnknownHostException) {
                logger.error((Object)("[Configuration Error] " + e.getMessage() + " /etc/hosts entry is missing"));
            }
            throw e;
        }
        this.createConfigPathFolder();
    }

    public static synchronized ApplicationProperties getInstance() throws InvalidPropertiesFormatException, IOException {
        if (m_Instance == null) {
            m_Instance = new ApplicationProperties();
        }
        return m_Instance;
    }

    private void loadProperties() throws InvalidPropertiesFormatException, IOException {
        InputStream inStream = this.getClass().getResourceAsStream(PROPERTIES_FILE_PATH);
        this.loadFromXML(inStream);
        String dir = System.getProperty(PRODUCT_DIR);
        String workflowroot = dir + File.separator + WORKFLOW_FOLDER_NAME;
        this.setProperty("install.dir", workflowroot);
        this.setProperty("clientClassesDirectory", workflowroot + File.separator + LIB_DIR);
        String conf = dir + File.separator + CONF_DIR + File.separator + WORKFLOW_FOLDER_NAME;
        this.setProperty("WorkflowApp.ConfigPath", conf);
        File file = new File(conf, URL_CONFIG_FILENAME);
        if (!file.exists()) {
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            if (!tmpDir.exists()) {
                tmpDir.mkdirs();
            }
            file = new File(tmpDir, URL_CONFIG_FILENAME);
            this.write(file, "com/tandbergtv/workflow/util/watch/url-config.xml");
        }
        Map<String, String> map = URLConfigReader.read(file);
        for (String urlKey : map.keySet()) {
            this.setProperty(urlKey, map.get(urlKey));
        }
    }

    private void createConfigPathFolder() {
        String configPath = this.getProperty("WorkflowApp.ConfigPath");
        if (configPath != null && configPath.trim().length() > 0) {
            File file = new File(configPath);
            try {
                if (!file.exists()) {
                    file.mkdirs();
                }
                logger.debug((Object)("The Workflow System configuration folder: " + file.getAbsolutePath() + " exists."));
            }
            catch (Exception ex) {
                String msg = "Failed to create the Workflow System configuration folder: " + file.getAbsolutePath();
                logger.error((Object)msg, (Throwable)ex);
            }
        } else {
            String msg = "The Workflow System configuration folder is not configured in the Application Properties, please enter a value for key: WorkflowApp.ConfigPath";
            logger.warn((Object)msg);
        }
    }

    void write(File file, String resource) {
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(resource);
            fos = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            int read = 0;
            while ((read = is.read(buf)) > 0) {
                fos.write(buf, 0, read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

