/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.util;

import com.n2bb.util.N2bbException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class OrbManager {
    private static Logger n2bbLog = Logger.getLogger(OrbManager.class);
    ORB m_orb;
    private static OrbManager instance;
    private static Properties orbProps;

    private OrbManager() throws Exception {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            this.initialize();
        }
        catch (Throwable t) {
            this.destroyORB();
            this.m_orb = null;
            throw new RuntimeException("Failed to initialize the ORB Manager.", t);
        }
    }

    private void initialize() throws Exception {
        String orbType;
        if (orbProps == null) {
            n2bbLog.warn((java.lang.Object)"Orb properties not set, using defaults!");
            orbProps = new Properties();
        }
        if ((orbType = orbProps.getProperty("orb", "JacORB")).equalsIgnoreCase("JacORB")) {
            String nameService = orbProps.getProperty("NameService", "corbaloc::AlertNameServer:4000/NameService");
            String timeout1 = orbProps.getProperty("jacorb.connection.client.pending_reply_timeout", "30000");
            String timeout2 = orbProps.getProperty("jacorb.connection.client.idle_timeout", "30000");
            String timeout3 = orbProps.getProperty("jacorb.connection.server.timeout", "30000");
            String[] args = new String[]{};
            n2bbLog.info((java.lang.Object)"creating JacORB orb");
            n2bbLog.info((java.lang.Object)("NameService... " + nameService));
            n2bbLog.info((java.lang.Object)("jacorb.connection.client.pending_reply_timeout=" + timeout1));
            n2bbLog.info((java.lang.Object)("jacorb.connection.client.idle_timeout=" + timeout2));
            n2bbLog.info((java.lang.Object)("jacorb.connection.server.timeout=" + timeout3));
            Properties props = new Properties();
            String settingsService = orbProps.getProperty("SettingsServer");
            if (settingsService != null) {
                n2bbLog.info((java.lang.Object)("SettingsService... " + settingsService));
                props.setProperty("ORBInitRef.SettingsService", settingsService);
            }
            props.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
            props.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
            props.setProperty("ORBInitRef.NameService", nameService);
            props.setProperty("jacorb.connection.client.pending_reply_timeout", timeout1);
            props.setProperty("jacorb.connection.client.idle_timeout", timeout2);
            props.setProperty("jacorb.connection.server.timeout", timeout3);
            this.m_orb = ORB.init((String[])args, (Properties)props);
        } else if (orbType.equalsIgnoreCase("Orbacus")) {
            java.lang.Object props;
            n2bbLog.info((java.lang.Object)"creating Orbabus orb");
            String nameService = orbProps.getProperty("NameService", "corbaloc::NameServer:5000/NameService");
            String timeout = orbProps.getProperty("ooc.orb.policy.timeout", "30000");
            String connectTimeout = orbProps.getProperty("ooc.orb.policy.connect_timeout", "30000");
            String requestTimeout = orbProps.getProperty("ooc.orb.policy.request_timeout", "30000");
            String[] args = null;
            String settingsService = orbProps.getProperty("SettingsServer");
            if (settingsService != null) {
                n2bbLog.info((java.lang.Object)("SettingsService... " + settingsService));
                props = new String[]{"-ORBproperty", "ooc.orb.service.NameService=" + nameService, "-ORBproperty", "ooc.orb.policy.timeout=" + timeout, "-ORBproperty", "ooc.orb.policy.connect_timeout=" + connectTimeout, "-ORBproperty", "ooc.orb.policy.request_timeout=" + requestTimeout, "-ORBInitRef", "SettingsService=" + settingsService};
                args = props;
            } else {
                props = new String[]{"-ORBproperty", "ooc.orb.service.NameService=" + nameService, "-ORBproperty", "ooc.orb.policy.timeout=" + timeout, "-ORBproperty", "ooc.orb.policy.connect_timeout=" + connectTimeout, "-ORBproperty", "ooc.orb.policy.request_timeout=" + requestTimeout, "-ORBInitRef"};
                args = props;
            }
            n2bbLog.info((java.lang.Object)("NameService... " + nameService));
            n2bbLog.info((java.lang.Object)("ooc.orb.policy.timeout=" + timeout));
            n2bbLog.info((java.lang.Object)("ooc.orb.policy.connect_timeout=" + connectTimeout));
            n2bbLog.info((java.lang.Object)("ooc.orb.policy.request_timeout=" + requestTimeout));
            props = new Properties();
            ((Properties)props).setProperty("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
            ((Properties)props).setProperty("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
            this.m_orb = ORB.init((String[])args, (Properties)props);
        } else {
            n2bbLog.error((java.lang.Object)"unknown orb type - must be JacOrb or Orbacus");
            throw new N2bbException("");
        }
    }

    public static synchronized void setProperties(Properties props) {
        n2bbLog.debug((java.lang.Object)"enter");
        if (instance == null) {
            orbProps = props;
        } else {
            n2bbLog.warn((java.lang.Object)"Orb manager already initialized.");
            n2bbLog.warn((java.lang.Object)"  To update properties, first call OrbManager.destroy()");
        }
    }

    public static synchronized OrbManager getInstance() {
        n2bbLog.debug((java.lang.Object)"enter");
        if (instance == null) {
            try {
                instance = new OrbManager();
            }
            catch (Exception e) {
                n2bbLog.error((java.lang.Object)"failed to initialize orb manager", (Throwable)e);
            }
        }
        return instance;
    }

    public static synchronized void destroy() {
        n2bbLog.debug((java.lang.Object)"enter");
        if (instance != null) {
            instance.destroyORB();
            instance = null;
            orbProps = null;
        }
    }

    public Object getFactoryObject(String factoryName) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        String[] path = new String[]{"Factories", factoryName};
        return this.getFactoryObject(path);
    }

    public Object getFactoryObject(String[] strFullPath) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            NamingContextExt ctx = this.getContext(strFullPath, strFullPath.length - 1);
            NameComponent[] nc = new NameComponent[]{new NameComponent(strFullPath[strFullPath.length - 1], "Factory")};
            Object obj = ctx.resolve(nc);
            if (obj == null) {
                throw new RuntimeException("Factory was null");
            }
            return obj;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.corba.findFactory");
        }
    }

    private NamingContextExt getContext(String[] strFullPath, int iLen) throws N2bbException {
        try {
            NameComponent[] nc = new NameComponent[iLen];
            for (int i = 0; i < iLen; ++i) {
                nc[i] = new NameComponent(strFullPath[i], "Context");
            }
            Object ctx = this.getNamingContextExt().resolve(nc);
            return NamingContextExtHelper.narrow((Object)ctx);
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }

    public Object getRootLevelObject(NameComponent[] nc) throws N2bbException {
        try {
            Object obj = this.getNamingContextExt().resolve(nc);
            return obj;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }

    public Vector getRootLevelContextObjects(String context) throws N2bbException {
        Vector<Object> objs = new Vector<Object>();
        try {
            NamingContextExt cxt = this.getRootLevelContext(context);
            if (cxt == null) {
                return objs;
            }
            Vector bindings = this.getBindings(cxt);
            for (int i = 0; i < bindings.size(); ++i) {
                try {
                    objs.addElement(cxt.resolve(((Binding)bindings.elementAt((int)i)).binding_name));
                    continue;
                }
                catch (Exception e) {
                    n2bbLog.error((java.lang.Object)("failed to resolve a binding - message... " + e.getMessage()), (Throwable)e);
                    n2bbLog.error((java.lang.Object)"  skipping this binding");
                }
            }
        }
        catch (N2bbException e) {
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
        return objs;
    }

    public HashMap getRootLevelContextObjectsMap(String context) throws N2bbException {
        HashMap<String, Object> nameObjMap = new HashMap<String, Object>();
        try {
            NamingContextExt cxt = this.getRootLevelContext(context);
            if (cxt == null) {
                return nameObjMap;
            }
            Vector bindings = this.getBindings(cxt);
            for (int i = 0; i < bindings.size(); ++i) {
                try {
                    NameComponent[] nc = ((Binding)bindings.elementAt((int)i)).binding_name;
                    nameObjMap.put(nc[nc.length - 1].id, cxt.resolve(nc));
                    continue;
                }
                catch (Exception e) {
                    n2bbLog.error((java.lang.Object)("failed to resolve a binding - message... " + e.getMessage()), (Throwable)e);
                    n2bbLog.error((java.lang.Object)"  skipping this binding");
                }
            }
        }
        catch (N2bbException e) {
            throw e;
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
        return nameObjMap;
    }

    private NamingContextExt getRootLevelContext(String contextName) throws N2bbException {
        try {
            boolean found = false;
            Binding bind = null;
            BindingListHolder blh = new BindingListHolder();
            BindingIteratorHolder bih = new BindingIteratorHolder();
            NamingContextExt nameCtxExt = this.getNamingContextExt();
            int blockSize = 50;
            nameCtxExt.list(blockSize, blh, bih);
            for (int i = 0; i < blh.value.length; ++i) {
                bind = blh.value[i];
                if (bind.binding_name[0].id.compareTo(contextName) != 0) continue;
                found = true;
                break;
            }
            if (!found && bih.value != null) {
                n2bbLog.debug((java.lang.Object)"more bindings");
                BindingIterator bi = bih.value;
                block3: while (bi.next_n(blockSize, blh)) {
                    n2bbLog.debug((java.lang.Object)"more bindings while");
                    for (int i = 0; i < blh.value.length; ++i) {
                        bind = blh.value[i];
                        if (bind.binding_name[0].id.compareTo(contextName) != 0) continue;
                        found = true;
                        continue block3;
                    }
                }
            }
            if (!found) {
                return null;
            }
            return NamingContextExtHelper.narrow((Object)nameCtxExt.resolve(bind.binding_name));
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }

    private Vector getBindings(NamingContextExt cxt) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        Vector<Binding> bindings = new Vector<Binding>();
        try {
            BindingListHolder blh = new BindingListHolder();
            BindingIteratorHolder bih = new BindingIteratorHolder();
            int blockSize = 50;
            cxt.list(blockSize, blh, bih);
            if (blh.value.length == 1 && blh.value[0] == null) {
                return bindings;
            }
            for (int i = 0; i < blh.value.length; ++i) {
                bindings.addElement(blh.value[i]);
            }
            if (bih.value != null) {
                n2bbLog.debug((java.lang.Object)"more bindings iter");
                BindingIterator bi = bih.value;
                while (bi.next_n(blockSize, blh)) {
                    n2bbLog.debug((java.lang.Object)"more bindings while");
                    for (int i = 0; i < blh.value.length; ++i) {
                        bindings.addElement(blh.value[i]);
                    }
                }
            }
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
        return bindings;
    }

    private void destroyORB() {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            if (this.m_orb != null) {
                this.m_orb.destroy();
            }
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
        }
    }

    public ORB getORB() {
        return this.m_orb;
    }

    public NamingContextExt getNamingContextExt() {
        try {
            Object ns = this.m_orb.resolve_initial_references("NameService");
            return NamingContextExtHelper.narrow((Object)ns);
        }
        catch (InvalidName ine) {
            throw new RuntimeException("Failed to get the name service.", ine);
        }
    }

    public void deleteBinding(NameComponent[] nc) throws N2bbException {
        n2bbLog.debug((java.lang.Object)"enter");
        try {
            this.getNamingContextExt().unbind(nc);
        }
        catch (Exception e) {
            n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.other");
        }
    }
}

