/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.registration;

import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.adaptor.registration.IDynamicProxyAdaptor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DynamicProxyAdaptor
implements IDynamicProxyAdaptor {
    private IAdaptor adaptor = null;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public DynamicProxyAdaptor(IAdaptor adaptor) {
        this.adaptor = adaptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(IAdaptorConfiguration conf) throws AdaptorException {
        this.lock.writeLock().lock();
        try {
            this.adaptor.init(conf);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.lock.writeLock().lock();
        try {
            this.adaptor.destroy();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAdaptorResponse transmit(IAdaptorRequest request) throws AdaptorException {
        this.lock.readLock().lock();
        try {
            IAdaptorResponse iAdaptorResponse = this.adaptor.transmit(request);
            return iAdaptorResponse;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDeliver(IAdaptorRequest request) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.adaptor.canDeliver(request);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IAdaptor adaptor) {
        this.lock.writeLock().lock();
        try {
            this.adaptor.destroy();
            this.adaptor = adaptor;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public IAdaptor getAdaptor() {
        return this.adaptor;
    }

    @Override
    public ReadWriteLock getAdaptorLock() {
        return this.lock;
    }
}

