/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.core.settings.SettingsPluginLoader;
import com.tandbergtv.workflow.driver.event.ProcessLogEvent;
import com.tandbergtv.workflow.log.EventSerializer;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.resourcemanager.event.WorkflowProcessStatusLogEvent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class LogEventListener
implements IColleague {
    private EventSerializer serializer;
    private ExecutorService eventProcessor;
    private final int MAX_SIZE = 5;
    private static final String THREADPOOL_SETTING_GROUP = "com.tandbergtv.workflow.application";
    private static final String THREADPOOL_SETTING = "com.tandbergtv.workflow.logger.threadPool.size";

    public LogEventListener(EventSerializer serializer) {
        this.serializer = serializer;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        this.eventProcessor = Executors.newFixedThreadPool(this.getThreadPoolSettings(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("Log Event Listener - " + threadNumber.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(final WorkflowEvent event) {
        if (!(event instanceof WorkflowMessageLogEvent || event instanceof WorkflowProcessStatusLogEvent || event instanceof ProcessLogEvent)) {
            return;
        }
        this.eventProcessor.execute(new Runnable(){

            @Override
            public void run() {
                if (event instanceof WorkflowMessageLogEvent) {
                    LogEventListener.this.serializer.serialize((WorkflowMessageLogEvent)event);
                } else if (event instanceof WorkflowProcessStatusLogEvent) {
                    LogEventListener.this.serializer.serialize((WorkflowProcessStatusLogEvent)event);
                } else if (event instanceof ProcessLogEvent) {
                    LogEventListener.this.serializer.serialize((ProcessLogEvent)event);
                }
            }
        });
    }

    private int getThreadPoolSettings() {
        SettingsPluginLoader settingsPluginLoader = new SettingsPluginLoader();
        ISettingsProvider provider = settingsPluginLoader.createSettingsProvider();
        if (provider == null) {
            return 5;
        }
        String size = provider.getProperties(THREADPOOL_SETTING_GROUP).get(THREADPOOL_SETTING);
        if (size != null) {
            return Integer.parseInt(size);
        }
        return 5;
    }
}

