/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.ui.chart;

import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.ui.AbstractImageWriter;
import com.tandbergtv.workflow.monitor.ui.chart.DataSetGenerator;
import com.tandbergtv.workflow.monitor.ui.chart.ImageGenerator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.management.JMException;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartUtilities;
import org.jfree.data.xy.XYDataset;

public class ImageWriter
extends AbstractImageWriter {
    private static final Logger logger = Logger.getLogger(ImageWriter.class);

    public ImageWriter(ISchedulerService<Void> pool, File root) {
        super(pool, root);
    }

    public String getServiceName() {
        return "image-writer";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void writeImage(File imageFile, Metric metricName) {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(imageFile);
                BufferedImage image = this.createTimeSeriesImage(this.root, metricName);
                ChartUtilities.writeBufferedImageAsPNG((OutputStream)out, (BufferedImage)image);
                return;
            }
            catch (IOException e) {
                logger.error((Object)"Error message", (Throwable)e);
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (JMException e) {
                logger.error((Object)"Error message", (Throwable)e);
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected BufferedImage createTimeSeriesImage(File root, Metric metric) throws IOException, JMException {
        XYDataset ds = new DataSetGenerator(root).createTimeSeries(metric);
        return new ImageGenerator().createImage(ds, metric.getType(), "Time", metric.getName(), 600, 480);
    }
}

