/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.monitor.core.ISample;
import com.tandbergtv.workflow.monitor.core.MetricSample;
import com.tandbergtv.workflow.monitor.internal.JMXMetric;
import com.tandbergtv.workflow.monitor.internal.MetricProcessor;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class Samples {
    private static final String MBEAN_PREFIX = "com.tandbergtv.watchpoint:type=Page,name=";

    public static void addSample(String name, long time) throws Exception {
        ISample sample = Samples.lookup(name);
        if (sample == null) {
            sample = new MetricSample(name);
            Samples.register(sample, name);
        }
        sample.add(time);
    }

    private static ISample lookup(String id) throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName(MBEAN_PREFIX + id);
            ISample sample = JMX.newMBeanProxy(server, name, ISample.class);
            server.getObjectInstance(name);
            return sample;
        }
        catch (JMException e) {
            return null;
        }
    }

    private static void register(ISample sample, String id) throws JMException {
        ObjectName name = new ObjectName(MBEAN_PREFIX + id);
        ManagementFactory.getPlatformMBeanServer().registerMBean(sample, name);
        MetricProcessor p = (MetricProcessor)ServiceRegistry.getDefault().lookup(MetricProcessor.class);
        if (p != null) {
            p.addMetricName(JMXMetric.fromObjectName(name, "EWMA"));
        }
    }
}

