/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.DatatypeConverter;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.TypeConversionException;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.ExtendedTransition;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IAuthorizationManager;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.jbpm.JbpmConfiguration;
import org.jbpm.context.def.ContextDefinition;
import org.jbpm.graph.action.ActionTypes;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.NodeTypes;
import org.jbpm.graph.node.StartState;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.xml.JpdlParser;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.jpdl.xml.ProblemListener;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ExtendedJpdlXmlReader
extends JpdlXmlReader {
    private static final long serialVersionUID = -1967585018835597672L;
    private static final Logger logger = Logger.getLogger(ExtendedJpdlXmlReader.class);
    protected Collection<ExtendedJpdlXmlReader> extensions;

    public ExtendedJpdlXmlReader() {
        this(null);
    }

    public ExtendedJpdlXmlReader(InputStream stream) {
        super(new InputSource(stream));
        this.unresolvedTransitionDestinations = new ArrayList();
        this.unresolvedActionReferences = new ArrayList();
        this.problems = new ArrayList();
        this.extensions = new ArrayList<ExtendedJpdlXmlReader>();
    }

    public void addExtension(ExtendedJpdlXmlReader reader) {
        reader.problems = this.problems;
        this.extensions.add(reader);
    }

    public Map<String, String> getPredefinedActions() {
        HashMap<String, String> actions = new HashMap<String, String>();
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(((Object)((Object)this)).getClass().getPackage().getName()) + ".action");
        for (String key : Collections.list(bundle.getKeys())) {
            actions.put(key, bundle.getString(key));
        }
        return actions;
    }

    public ProcessDefinition readProcessDefinition() {
        logger.debug((Object)"Reading process definition XML");
        org.dom4j.Element root = null;
        try {
            root = JpdlParser.parse((InputSource)this.inputSource, (ProblemListener)this).getRootElement();
        }
        catch (Exception e) {
            throw new TemplateReaderException("Failed to parse the document", e);
        }
        String className = root.attributeValue("class", WorkflowTemplate.class.getName());
        logger.debug((Object)("Creating template of type " + className));
        try {
            this.processDefinition = (ProcessDefinition)Class.forName(className).newInstance();
            this.processDefinition.addDefinition((ModuleDefinition)new TaskMgmtDefinition());
            this.processDefinition.addDefinition((ModuleDefinition)new ContextDefinition());
            for (ExtendedJpdlXmlReader extension : this.extensions) {
                extension.processDefinition = this.processDefinition;
            }
            this.parseProcessDefinitionAttributes(root);
            this.readActions(root, null, null);
            this.readNodes(root, (NodeCollection)this.processDefinition);
            this.readEvents(root, (GraphElement)this.processDefinition);
            this.readExceptionHandlers(root, (GraphElement)this.processDefinition);
            this.readTasks(root, null);
            this.resolveTransitionDestinations();
            this.resolveActionReferences();
        }
        catch (ClassNotFoundException e) {
            this.addError("Failed to load class " + className, e);
        }
        catch (Throwable t) {
            this.addError("Failed to compile template - " + t.getMessage(), t);
        }
        if (Problem.containsProblemsOfLevel((Collection)this.problems, (int)2)) {
            throw new TemplateReaderException(this.problems);
        }
        if (Problem.containsProblemsOfLevel((Collection)this.problems, (int)3)) {
            for (ExtendedJpdlXmlReader obj : this.problems) {
                Problem warn = (Problem)obj;
                if (warn.getLevel() != 3 || warn.getDescription().contains("swimlane")) continue;
                logger.warn((Object)warn.getDescription());
            }
        }
        return this.processDefinition;
    }

    protected void parseProcessDefinitionAttributes(org.dom4j.Element root) {
        String version;
        super.parseProcessDefinitionAttributes(root);
        if (this.processDefinition instanceof Parsable) {
            ((Parsable)Parsable.class.cast(this.processDefinition)).read(root, (JpdlXmlReader)this);
        }
        if ((version = root.attributeValue("version")) == null || version.length() == 0) {
            this.addError("Template " + this.processDefinition.getName() + " must have a version");
        } else {
            this.processDefinition.setVersion(Integer.valueOf(version).intValue());
        }
        this.parseProtectionKeys(root);
    }

    protected void parseProtectionKeys(org.dom4j.Element root) {
        IAuthorizationManager manager = (IAuthorizationManager)ServiceRegistry.getDefault().lookup(IAuthorizationManager.class);
        if (manager == null) {
            this.addError("Unable to get protection keys, service is unavailable");
            return;
        }
        List list = root.elements("protection-key");
        if (list == null || list.size() == 0) {
            return;
        }
        for (org.dom4j.Element e : list) {
            String name = e.attributeValue("name");
            if (name == null || name.length() == 0) {
                this.addError("Protection key name must be specified");
                continue;
            }
            ProtectionKey key = manager.getProtectionKey(name);
            if (key == null) {
                key = new ProtectionKey(name);
                manager.addProtectionKey(key);
            }
            logger.debug((Object)("Adding protection key " + name));
            if (!(this.processDefinition instanceof WorkflowTemplate)) continue;
            ((WorkflowTemplate)this.processDefinition).addProtectionKey(key);
        }
    }

    public void readNodes(org.dom4j.Element element, NodeCollection nodeCollection) {
        Iterator i = element.elementIterator();
        while (i.hasNext()) {
            org.dom4j.Element e = (org.dom4j.Element)i.next();
            String name = e.getName();
            Class type = NodeTypes.getNodeType((String)name);
            if (type == null) continue;
            Node node = null;
            try {
                node = (Node)type.newInstance();
            }
            catch (Exception exception) {
                this.addError("Couldn't instantiate node " + name + " of type " + type.getName(), exception);
                continue;
            }
            node.setProcessDefinition(this.processDefinition);
            if (node instanceof StartState && this.processDefinition.getStartState() != null) {
                this.addError("At most one start-state allowed in a process");
                continue;
            }
            this.readNode(e, node, nodeCollection);
            node.read(e, (JpdlXmlReader)this);
            for (JpdlXmlReader jpdlXmlReader : this.extensions) {
                jpdlXmlReader.readNode(e, node, nodeCollection);
            }
        }
    }

    public void readAction(org.dom4j.Element element, Action action) {
        String clazz = element.attributeValue("class");
        if ("send".equals(clazz)) {
            element.attribute("class").setValue("com.tandbergtv.workflow.exe.message.MessageEmitter");
        }
        super.readAction(element, action);
    }

    public List<?> readVariableAccesses(org.dom4j.Element element) {
        ArrayList<TaskVariable> variables = new ArrayList<TaskVariable>();
        Iterator i = element.elementIterator("variable");
        while (i.hasNext()) {
            org.dom4j.Element e = (org.dom4j.Element)i.next();
            String name = e.attributeValue("name");
            String access = e.attributeValue("access", "read,write,required");
            String mappedName = e.attributeValue("mapped-name");
            String type = e.attributeValue("type", Datatype.STRING.toString());
            String initialValue = e.attributeValue("value", null);
            try {
                Datatype datatype = Datatype.valueOf((String)type);
                TaskVariable variable = new TaskVariable(name, access, mappedName, datatype);
                if (initialValue != null) {
                    if (datatype == Datatype.LIST) {
                        this.setInitialValueForList(variable, initialValue);
                    } else if (datatype != Datatype.STRING) {
                        this.setInitialValueForNonString(variable, initialValue, datatype);
                    } else {
                        variable.setInitialValue(initialValue);
                    }
                }
                variables.add(variable);
                logger.debug((Object)("Added variable " + name + " type " + datatype.toString()));
            }
            catch (IllegalArgumentException e1) {
                this.addError("Variable " + name + " has invalid type (" + type + ") - " + e1.getMessage(), e1);
            }
        }
        return variables;
    }

    private void setInitialValueForList(TaskVariable variable, String initialValue) {
        String[] listValues = initialValue.split(",");
        int i = 0;
        while (i < listValues.length) {
            try {
                new DatatypeConverter().convert((Object)listValues[i], Datatype.STRING);
            }
            catch (TypeConversionException e1) {
                this.addWarning("Variable " + variable.getVariableName() + ":" + i + " - " + e1.getMessage());
            }
            ++i;
        }
        variable.setInitialValue(initialValue);
    }

    private void setInitialValueForNonString(TaskVariable variable, String initialValue, Datatype datatype) {
        try {
            new DatatypeConverter().convert((Object)initialValue, datatype);
        }
        catch (TypeConversionException e2) {
            this.addWarning("Variable " + variable.getVariableName() + " - " + e2.getMessage());
        }
        variable.setInitialValue(initialValue);
    }

    public void resolveTransitionDestination(org.dom4j.Element transitionElement, Node node) {
        ExtendedTransition transition = new ExtendedTransition();
        transition.setProcessDefinition(this.processDefinition);
        String name = transitionElement.attributeValue("name");
        if (name != null) {
            transition.setName(name);
        }
        node.addLeavingTransition((Transition)transition);
        String toName = transitionElement.attributeValue("to");
        if (toName == null) {
            this.addError("Node " + node.getName() + " has a transition without a destination node");
            return;
        }
        Node to = ((NodeCollection)node.getParent()).findNode(toName);
        if (to == null) {
            this.addError("Cannot make transition to non existent node " + toName + " from " + node.getName());
            return;
        }
        to.addArrivingTransition((Transition)transition);
        if (to instanceof ManualTaskNode) {
            org.dom4j.Element notificationAction = transitionElement.addElement("action");
            String className = "com.tandbergtv.workflow.exe.email.QueuedTaskNotificationHandler";
            notificationAction.addAttribute("class", className);
        }
        this.readActions(transitionElement, (GraphElement)transition, "transition");
    }

    public void resolveActionReferences() {
        this.addActions(this.getPredefinedActions());
        for (ExtendedJpdlXmlReader extension : this.extensions) {
            this.addActions(extension.getPredefinedActions());
        }
        super.resolveActionReferences();
    }

    protected void addActions(Map<String, String> map) {
        for (String key : map.keySet()) {
            Action action = new Action();
            action.setName(key);
            action.setProcessDefinition(this.processDefinition);
            action.setActionDelegation(new Delegation(map.get(key)));
            this.processDefinition.addAction(action);
        }
    }

    protected void readExceptionHandler(org.dom4j.Element element, GraphElement graphElement) {
        Iterator i = element.elementIterator();
        if (i.hasNext()) {
            org.dom4j.Element e = (org.dom4j.Element)i.next();
            if (!ActionTypes.hasActionName((String)e.getName())) {
                this.addError("Unknown element '" + e.getName() + "' found in exception handler for " + graphElement.getName());
            } else {
                String name = e.attributeValue("class");
                if (name == null || name.trim().length() == 0) {
                    this.addError("Exception handler name is not defined for " + graphElement.getName());
                    return;
                }
                String className = this.getExceptionHandlerClassName(name);
                if (className != null) {
                    e.attribute("class").setValue(className);
                    ExceptionHandler exceptionHandler = new ExceptionHandler();
                    exceptionHandler.addAction(this.createAction(e));
                    graphElement.addExceptionHandler(exceptionHandler);
                }
            }
        }
    }

    protected String getExceptionHandlerClassName(String name) {
        String resource = JbpmConfiguration.Configs.getString((String)"resource.exception.types");
        InputStream is = ClassLoaderUtil.getStream((String)resource);
        try {
            Element types = XmlUtil.parseXmlInputStream((InputStream)is).getDocumentElement();
            Iterator i = XmlUtil.elementIterator((Element)types, (String)"exception-type");
            while (i.hasNext()) {
                Element element = (Element)i.next();
                String elementTag = element.getAttribute("element");
                if (!elementTag.equalsIgnoreCase(name)) continue;
                String string = element.getAttribute("class");
                return string;
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

