/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.TokenError;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmSeverity;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class ProcessAlarmNotificationProvider
implements IAlarmNotificationProvider {
    private AtomicInteger counter = new AtomicInteger(0);

    public Set<AlarmNotification> getAlarms(long timestamp) {
        HashSet<AlarmNotification> set = new HashSet<AlarmNotification>();
        for (WorkflowProcess process : this.getFailedProcesses()) {
            set.add(this.makeAlarm(process));
        }
        return set;
    }

    private Collection<WorkflowProcess> getFailedProcesses() {
        HashSet<WorkflowProcess> list = new HashSet<WorkflowProcess>();
        ICacheService<WorkflowProcess> cache = this.getCache();
        for (Serializable key : cache.getKeys()) {
            WorkflowProcess process = (WorkflowProcess)cache.get(key);
            if (process == null || !this.match(process)) continue;
            list.add(process);
        }
        return list;
    }

    private boolean match(WorkflowProcess process) {
        for (CustomToken token : process.findAllTokens()) {
            if (token.getStatus() != ProcessStatus.ERROR) continue;
            return true;
        }
        return false;
    }

    private ICacheService<WorkflowProcess> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    private AlarmNotification makeAlarm(WorkflowProcess process) {
        TokenError error = process.getRootToken().getErrorDetails();
        int seq = this.counter.getAndIncrement();
        AlarmNotification notification = new AlarmNotification((Object)process, (long)seq, AlarmSeverity.ERROR, error.getCategory().name(), error.getTime().getTime(), error.getMessage());
        return notification;
    }
}

