/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSVariableInstance;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsParameters;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;

public class WfsEsProcessHelper {
    private static Logger logger = Logger.getLogger(WfsEsProcessHelper.class);
    private static WfsEsProcessHelper instance = new WfsEsProcessHelper();

    private WfsEsProcessHelper() {
    }

    public static WfsEsProcessHelper getInstance() {
        return instance;
    }

    public XContentBuilder createProcess(WorkflowProcess process) throws IOException {
        if (process == null || process.getId() < 1L || process.getRootToken() == null) {
            throw new IllegalArgumentException("Process appears to be invalid");
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.prettyPrint();
        builder.startObject();
        this.addSearchFields(builder, process);
        builder.endObject();
        return builder;
    }

    public boolean trySaving(String id, XContentBuilder source, TransportClient client) {
        if (client == null) {
            logger.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            IndexRequestBuilder bld = client.prepareIndex("wfs", "processinstance", id);
            bld.setSource(source);
            bld.execute().actionGet(3000L);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Could not index process " + id), (Throwable)e);
            return false;
        }
    }

    public boolean tryDeleting(String id, TransportClient client) {
        if (client == null) {
            logger.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            DeleteRequestBuilder bld = client.prepareDelete("wfs", "processinstance", id);
            bld.execute().actionGet(3000L);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Could not delete process " + id), (Throwable)e);
            return false;
        }
    }

    private void addSearchFields(XContentBuilder bldr, WorkflowProcess proc) {
        this.addSearchableField(bldr, "id", proc.getId());
        this.addSearchableField(bldr, "templateId", proc.getProcessDefinition().getId());
        this.addSearchableField(bldr, "templateName", proc.getProcessDefinition().getFullName());
        this.addSearchableField(bldr, "adminStatus", proc.getRootToken().getRequestedStatus());
        this.addSearchableField(bldr, "status", proc.getRootToken().getStatus());
        Set vars = proc.getVariables();
        boolean titleIdFound = false;
        boolean titleBriefFound = false;
        boolean licenseStartFound = false;
        boolean licenseEndFound = false;
        boolean providerIdFound = false;
        for (WFSVariableInstance var : vars) {
            if (titleIdFound && titleBriefFound && licenseStartFound && licenseEndFound && providerIdFound) break;
            if ("titleId".equalsIgnoreCase(var.getName()) || "title_id".equalsIgnoreCase(var.getName())) {
                this.addSearchableField(bldr, "titleId", var.getStringVal());
                titleIdFound = true;
                continue;
            }
            if ("titleBrief".equalsIgnoreCase(var.getName()) || "title_brief".equalsIgnoreCase(var.getName())) {
                this.addSearchableField(bldr, "titleBrief", var.getStringVal());
                titleBriefFound = true;
                continue;
            }
            if ("licenseStart".equalsIgnoreCase(var.getName()) || "license_start".equalsIgnoreCase(var.getName())) {
                this.addSearchableField(bldr, "licenseStart", var.getStringVal());
                licenseStartFound = true;
                continue;
            }
            if ("licenseEnd".equalsIgnoreCase(var.getName()) || "license_end".equalsIgnoreCase(var.getName())) {
                this.addSearchableField(bldr, "licenseEnd", var.getStringVal());
                licenseEndFound = true;
                continue;
            }
            if (!"providerId".equalsIgnoreCase(var.getName()) && !"provider_id".equalsIgnoreCase(var.getName())) continue;
            this.addSearchableField(bldr, "providerId", var.getStringVal());
            providerIdFound = true;
        }
        this.addSearchableField(bldr, "currentTask", proc.getRootToken().getCurrentNode().getName());
        this.addSearchableField(bldr, "startTime", proc.getStart());
        this.addSearchableField(bldr, "endTime", proc.getEnd());
        if (proc.getSuperProcessToken() != null) {
            this.addSearchableField(bldr, "superProcessTokenId", proc.getSuperProcessToken().getId());
        } else {
            this.addSearchableField(bldr, "superProcessTokenId", null);
        }
        if (proc.getRootToken().getChildren() != null && proc.getRootToken().getChildren().size() > 0) {
            this.addSearchableField(bldr, "hasChildren", true);
        } else {
            this.addSearchableField(bldr, "hasChildren", false);
        }
        this.addSearchableField(bldr, "rootTokenId", proc.getRootToken().getId());
        if (proc.getRootToken().getErrorDetails() != null) {
            this.addSearchableField(bldr, "errorTime", proc.getRootToken().getErrorDetails().getTime());
            this.addSearchableField(bldr, "errorComment", proc.getRootToken().getErrorDetails().getMessage());
        }
    }

    private void addSearchableField(XContentBuilder bldr, String key, Object value) {
        try {
            bldr.field(key, value);
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot add field", (Throwable)ex);
        }
    }

    public void addResultProperties(SearchRequestBuilder bld) {
        bld.addField("id");
        bld.addField("hasChildren");
        bld.addField("rootTokenId");
        bld.addField("superProcessTokenId");
        bld.addField("providerId");
        bld.addField("templateId");
        bld.addField("templateName");
        bld.addField("adminStatus");
        bld.addField("status");
        bld.addField("titleId");
        bld.addField("titleBrief");
        bld.addField("licenseStart");
        bld.addField("licenseEnd");
        bld.addField("currentTask");
        bld.addField("startTime");
        bld.addField("endTime");
        bld.addField("errorTime");
        bld.addField("errorComment");
    }

    public long getLongField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? -1L : Long.parseLong(value.toString());
    }

    public String getStringField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? "" : value.toString();
    }

    public int getIntField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? -1 : Integer.parseInt(value.toString());
    }

    public Date getDateField(SearchHit hit, String fieldName) throws ParseException {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? null : WfsEsParameters.dateformatter.parse(value.toString());
    }

    public boolean getBooleanField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? false : Boolean.parseBoolean(value.toString());
    }

    public WFSearchResult convert(SearchHit hit, long totalCount) {
        if (hit == null) {
            throw new IllegalArgumentException("SearchHit is null");
        }
        WFSearchResult result = new WFSearchResult();
        result.setProcessId(this.getLongField(hit, "id"));
        WFToken rootToken = new WFToken();
        rootToken.setTokenId(this.getLongField(hit, "rootTokenId"));
        rootToken.setProcessId(result.getProcessId());
        rootToken.setAdministrativeStatus(ProcessStatus.valueOf((String)this.getStringField(hit, "adminStatus")).ordinal());
        rootToken.setOperationalStatus(ProcessStatus.valueOf((String)this.getStringField(hit, "status")).ordinal());
        rootToken.setNodeName(this.getStringField(hit, "currentTask"));
        try {
            rootToken.setStartTime(this.getDateField(hit, "startTime"));
            rootToken.setEndTime(this.getDateField(hit, "endTime"));
            rootToken.setErrorTime(this.getDateField(hit, "errorTime"));
            rootToken.setErrorComment(this.getStringField(hit, "errorComment"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        result.setToken(rootToken);
        WFVariable titleId = new WFVariable();
        titleId.setName("titleId");
        titleId.addValue(this.getStringField(hit, "titleId"));
        result.addVariable(titleId);
        WFVariable titleBrief = new WFVariable();
        titleBrief.setName("titleBrief");
        titleBrief.addValue(this.getStringField(hit, "titleBrief"));
        result.addVariable(titleBrief);
        WFVariable licenseStart = new WFVariable();
        licenseStart.setName("licenseStart");
        licenseStart.addValue(this.getStringField(hit, "licenseStart"));
        result.addVariable(licenseStart);
        WFVariable licenseEnd = new WFVariable();
        licenseEnd.setName("licenseEnd");
        licenseEnd.addValue(this.getStringField(hit, "licenseEnd"));
        result.addVariable(licenseEnd);
        WFVariable providerId = new WFVariable();
        providerId.setName("providerId");
        providerId.addValue(this.getStringField(hit, "providerId"));
        result.addVariable(providerId);
        if (this.getBooleanField(hit, "hasChildren")) {
            result.addChild(new WFSearchResult());
        }
        result.setProcessDefinitionName(this.getStringField(hit, "templateName"));
        result.setSearchResultCount(totalCount);
        this.setNodeName(result.getProcessDefinitionName(), result.getToken());
        return result;
    }

    private void setNodeName(String templateName, final WFToken token) {
        ITemplateLoaderService templateLoaderService = (ITemplateLoaderService)ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        WorkflowTemplate template = templateLoaderService.getTemplateByFullName(templateName);
        if (template != null) {
            template.breadthFirstTraversal(new NodeVisitor(){

                public void visit(Node node) {
                    Node currentNode;
                    if (node instanceof SuperState && (currentNode = ((SuperState)node).getNode(token.getNodeName())) != null) {
                        token.setNodeName(node.getName());
                    }
                }
            });
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Singleton class does not allow cloning!");
    }
}

