/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.TokenError;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmSeverity;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import com.tandbergtv.workflow.monitor.core.alarm.Intent;
import com.tandbergtv.workflow.monitor.core.alarm.IntentAction;
import com.tandbergtv.workflow.monitor.core.alarm.IntentOperation;
import java.io.Serializable;
import java.net.URI;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ProcessAlarmNotificationProvider
implements IAlarmNotificationProvider {
    private static final Logger logger = Logger.getLogger(ProcessAlarmNotificationProvider.class);
    public static final String ALARM_RECOVERY_URL = "/workflow/process/";
    private AtomicInteger counter = new AtomicInteger(0);

    public Set<AlarmNotification> getAlarms(long timestamp) {
        HashSet<AlarmNotification> set = new HashSet<AlarmNotification>();
        Calendar dateCutoff = Calendar.getInstance();
        dateCutoff.setTimeInMillis(timestamp);
        for (WorkflowProcess process : this.getFailedProcesses(dateCutoff)) {
            AlarmNotification alarm = this.buildAlarm(process);
            if (alarm == null) continue;
            set.add(alarm);
        }
        return set;
    }

    private Collection<WorkflowProcess> getFailedProcesses(Calendar dateCutoff) {
        HashSet<WorkflowProcess> list = new HashSet<WorkflowProcess>();
        ICacheService<WorkflowProcess> cache = this.getCache();
        for (Serializable key : cache.getKeys()) {
            WorkflowProcess process = (WorkflowProcess)cache.get(key);
            if (process == null || !this.match(process, dateCutoff)) continue;
            list.add(process);
        }
        return list;
    }

    private boolean match(WorkflowProcess process, Calendar dateCutoff) {
        for (CustomToken token : process.findAllTokens()) {
            if (token.getStatus() != ProcessStatus.ERROR || !dateCutoff.getTime().before(token.getStart())) continue;
            return true;
        }
        return false;
    }

    private ICacheService<WorkflowProcess> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    private AlarmNotification buildAlarm(WorkflowProcess process) {
        TokenError error = process.getRootToken().getErrorDetails();
        if (error == null) {
            Collection childTokens = process.getRootToken().getChildTokens();
            for (CustomToken token : childTokens) {
                if (token.getStatus() != ProcessStatus.ERROR) continue;
                error = token.getErrorDetails();
                break;
            }
        }
        try {
            int seq = this.counter.getAndIncrement();
            AlarmNotification notification = new AlarmNotification((Object)process, (long)seq, AlarmSeverity.Error, error.getCategory().name(), error.getTime().getTime(), error.getMessage());
            URI recoveryUrl = new URI(ALARM_RECOVERY_URL + process.getId());
            if (process.getCanBeRetried()) {
                notification.addAction(Intent.newInstance((IntentOperation)IntentOperation.Retry, (IntentAction)IntentAction.Command, (URI)recoveryUrl));
            }
            if (process.getCanBeRestarted() && error.getCategory() != ErrorCategory.TIMEOUT) {
                notification.addAction(Intent.newInstance((IntentOperation)IntentOperation.Restart, (IntentAction)IntentAction.Command, (URI)recoveryUrl));
            }
            if (process.getCanBeCancelled()) {
                notification.addAction(Intent.newInstance((IntentOperation)IntentOperation.Cancel, (IntentAction)IntentAction.Command, (URI)recoveryUrl));
            }
            return notification;
        }
        catch (Exception e) {
            logger.error((Object)("Error occured building alarm for process " + process.getId()), (Throwable)e);
            this.counter.getAndDecrement();
            return null;
        }
    }
}

