/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;

public class MemoryPersistenceService
implements IPersistenceService {
    private static final String FORMAT_2 = "[Process] {0}, template {1}";
    private static final String FORMAT_1 = "[Process] {0}, template {1}, parent {2}";
    private static final Logger logger = Logger.getLogger(MemoryPersistenceService.class);

    @Override
    public Serializable create(WorkflowProcess process) {
        CustomToken rootToken = process.getRootToken();
        WorkflowTemplate template = process.getProcessDefinition();
        long id = Cluster.generateId((String)process.getClass().getName());
        this.setId(process, id);
        if (Cluster.owner((Object)process.getId())) {
            this.getCache().add((Serializable)Long.valueOf(process.getId()), (Object)process);
        } else {
            this.updateCache(process);
        }
        CustomToken superProcessToken = process.getSuperProcessToken();
        if (superProcessToken != null) {
            WorkflowProcess parent = superProcessToken.getProcessInstance();
            this.getCache().add((Serializable)Long.valueOf(parent.getId()), (Object)parent);
            logger.info((Object)MessageFormat.format(FORMAT_1, rootToken, template.getFullName(), superProcessToken));
        } else {
            logger.info((Object)MessageFormat.format(FORMAT_2, rootToken, template.getFullName()));
        }
        return Long.valueOf(process.getId());
    }

    @Override
    public WorkflowProcess get(Serializable id) {
        return (WorkflowProcess)this.getCache().get(id);
    }

    @Override
    public List<WorkflowProcess> getAll(List<String> ids) {
        ArrayList<WorkflowProcess> processes = new ArrayList<WorkflowProcess>();
        for (Serializable serializable : ids) {
            processes.add((WorkflowProcess)this.getCache().get(serializable));
        }
        return processes;
    }

    @Override
    public CustomToken getToken(Serializable id) {
        return this.get(id).getRootToken();
    }

    @Override
    public void persist(WorkflowProcess process) {
        if (process.hasEnded() || !process.isActive()) {
            this.getCache().remove((Serializable)Long.valueOf(process.getId()));
        } else {
            this.save(process);
        }
    }

    @Override
    public void save(WorkflowProcess process) {
        this.getCache().add((Serializable)Long.valueOf(process.getId()), (Object)process);
    }

    @Override
    public void save(CustomToken token) {
        this.save(token.getProcessInstance());
    }

    public String getServiceName() {
        return "Process Persistence";
    }

    public void start() {
    }

    public void stop() {
    }

    private ICacheService<WorkflowProcess> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    private void setId(Object object, long id) {
        try {
            Field field = object.getClass().getSuperclass().getDeclaredField("id");
            field.setAccessible(true);
            field.set(object, id);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        if (object instanceof WorkflowProcess) {
            this.setId(((WorkflowProcess)object).getRootToken(), id);
        }
    }

    private void updateCache(WorkflowProcess process) {
        ConcurrentMap map = ((IDistributedCache)this.getCache()).getMap();
        map.put(process.getId(), process);
    }
}

