/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.IProcessFactory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.internal.VariableInitializer;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.license.ILicenseProvider;
import com.tandbergtv.workflow.license.ILicenseProviderService;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ProcessDefinition;

public class ProcessFactory
implements IProcessFactory {
    private static final Logger logger = Logger.getLogger(ProcessFactory.class);
    private static final String SYSTEM_PROP_SELECTOR_KEYS = "com.tandbergtv.workflow.process.runtime.selectorKeys";

    public WorkflowProcess create(ProcessDefinition template, ProcessPriority priority, Map<String, Object> parameters) {
        WorkflowProcess process = null;
        try {
            Map<String, Object> copy = this.getInitialVariables(template, parameters);
            process = new WorkflowProcess(template, priority);
            for (String name : copy.keySet()) {
                process.getContextInstance().setVariable(name, copy.get(name));
            }
            this.postCreate(process);
        }
        catch (DriverException e) {
            throw new DriverRuntimeException(e);
        }
        return process;
    }

    public WorkflowProcess create(CustomToken token, ProcessDefinition template, Map<String, Object> parameters) {
        WorkflowProcess process = null;
        token.getProcessInstance().lock();
        try {
            try {
                Map<String, Object> copy = this.getInitialVariables(template, parameters);
                process = token.createSubProcessInstance(template);
                for (String name : copy.keySet()) {
                    process.getContextInstance().setVariable(name, copy.get(name));
                }
                this.postCreate(process);
            }
            catch (DriverException e) {
                throw new DriverRuntimeException(ErrorCategory.CHILD_PROCESS_LAUNCH_FAIL.name(), e);
            }
        }
        finally {
            token.getProcessInstance().unlock();
        }
        return process;
    }

    public WorkflowProcess start(CustomToken token, ProcessDefinition template, Map<String, Object> parameters) {
        WorkflowProcess process = this.create(token, template, parameters);
        try {
            this.getService().start(process.getRootToken());
        }
        catch (DriverException e) {
            throw new DriverRuntimeException(e);
        }
        return process;
    }

    protected void postCreate(WorkflowProcess process) {
        process.setLogLevel(this.getLogLevel());
        this.setIngestSelectorkeyVariable(process);
        IPersistenceService service = (IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        service.create(process);
        this.getCounter().created(process.getRootToken());
        this.checkLicense(process);
    }

    private boolean isIngestWO(WorkflowProcess process) {
        String selectorKeysString = System.getProperty(SYSTEM_PROP_SELECTOR_KEYS);
        if (selectorKeysString == null || selectorKeysString.isEmpty()) {
            return false;
        }
        Set templateSelectorkeys = process.getProcessDefinition().getSelectorKeys();
        if (templateSelectorkeys == null || templateSelectorkeys.size() == 0) {
            return false;
        }
        Iterator itr = templateSelectorkeys.iterator();
        while (itr.hasNext()) {
            String sk1 = ((Selector)itr.next()).getSelectionKey();
            if (!("," + selectorKeysString + ",").contains("," + sk1 + ",")) continue;
            return true;
        }
        return false;
    }

    private void checkLicense(WorkflowProcess process) {
        if (!this.isIngestWO(process)) {
            return;
        }
        ILicenseProviderService licenseService = (ILicenseProviderService)ServiceRegistry.getDefault().lookup(ILicenseProviderService.class);
        if (licenseService == null) {
            logger.error((Object)"License Provider Service not found");
            return;
        }
        ILicenseProvider provider = licenseService.getLicenseProvider();
        if (provider == null) {
            logger.info((Object)"License Provider is null");
            return;
        }
        String errorString = "";
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        try {
            String ingestThruPut = provider.getProperty("ingest.thruput");
            int ingestLimit = Integer.parseInt(ingestThruPut);
            if (ingestLimit == 0) {
                return;
            }
            IProcessSearchService searchService = (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
            int currentCount = searchService.ingestCount(cal.getTime());
            if (ingestLimit - currentCount >= 1) {
                return;
            }
            errorString = "License Limit for Ingest Thruput exceeded. Forcing work order to fail.";
        }
        catch (NumberFormatException nfe) {
            errorString = "Invalid Ingest Thruput limit. Forcing work order to fail.";
        }
        catch (Exception e) {
            errorString = "Failed to read Ingest Thruput limit. Forcing work order to fail.";
        }
        logger.warn((Object)errorString);
        process.getRootToken().fail((Throwable)new Exception(errorString));
    }

    private void setIngestSelectorkeyVariable(WorkflowProcess process) {
        if (this.isIngestWO(process)) {
            process.getContextInstance().setVariable("ingestTemplate", (Object)true);
        }
    }

    protected LogLevel getLogLevel() {
        String level = this.getService().getProperties().getProperty("log.level", LogLevel.ALL.toString());
        return LogLevel.valueOf((String)level.toUpperCase());
    }

    protected IProcessCounter getCounter() {
        return (IProcessCounter)((Object)this.getService().getStatistics().getCumulativeStatistics());
    }

    protected Map<String, Object> getInitialVariables(ProcessDefinition template, Map<String, Object> parameters) throws DriverException {
        return new VariableInitializer(template, parameters).initialize();
    }

    private IProcessManagerService getService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }
}

