/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.internal.monitor.ManualTaskAlarmNotification;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessAlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class GenericAlarmNotificationProvider
implements IAlarmNotificationProvider {
    private static final Logger logger = Logger.getLogger(GenericAlarmNotificationProvider.class);
    public static final String ALARM_RECOVERY_URL = "/workflow/process/";
    public static final String CHILD_PROCESS_ERROR_MSG_PREFIX = "alarms.childProcess.error.prefix";
    Collection<WorkflowProcess> processAlarmList = new HashSet<WorkflowProcess>();
    Collection<WorkflowProcess> manualTaskList = new HashSet<WorkflowProcess>();
    ProcessAlarmNotification processAlarmNotificationProvider = new ProcessAlarmNotification();
    ManualTaskAlarmNotification manualTaskAlarmNotificationProvider = new ManualTaskAlarmNotification();

    public Set<AlarmNotification> getAlarms(long timestamp) {
        HashSet<AlarmNotification> set = new HashSet<AlarmNotification>();
        Calendar dateCutoff = Calendar.getInstance();
        dateCutoff.setTimeInMillis(timestamp);
        long lStartTime = System.nanoTime();
        this.getFailedProcesses(dateCutoff);
        long lEndTime = System.nanoTime();
        long difference = lEndTime - lStartTime;
        logger.info((Object)("Elapsed milliseconds to get Failed Processes : " + difference / 1000000L));
        lStartTime = System.nanoTime();
        for (WorkflowProcess process : this.processAlarmList) {
            AlarmNotification alarm = this.processAlarmNotificationProvider.buildAlarm(process);
            if (alarm == null) continue;
            set.add(alarm);
        }
        lEndTime = System.nanoTime();
        difference = lEndTime - lStartTime;
        logger.info((Object)("Elapsed milliseconds to build all Process Alarms : " + difference / 1000000L));
        lStartTime = System.nanoTime();
        for (WorkflowProcess process : this.manualTaskList) {
            set.addAll(this.manualTaskAlarmNotificationProvider.buildAlarmsForProcess(process));
        }
        lEndTime = System.nanoTime();
        difference = lEndTime - lStartTime;
        logger.info((Object)("Elapsed milliseconds to build all ManualTask Alarms : " + difference / 1000000L));
        this.clearList();
        return set;
    }

    private void getFailedProcesses(Calendar dateCutoff) {
        ICacheService<WorkflowProcess> cache = this.getCache();
        for (Serializable key : cache.getKeys()) {
            WorkflowProcess process = (WorkflowProcess)cache.get(key);
            if (process == null) continue;
            this.match(process, dateCutoff);
        }
    }

    private void match(WorkflowProcess process, Calendar dateCutoff) {
        for (CustomToken token : process.findAllTokens()) {
            if (token.getStatus() == ProcessStatus.ERROR && dateCutoff.getTime().before(token.getStart())) {
                this.processAlarmList.add(process);
                continue;
            }
            if (token.getStatus() != ProcessStatus.BUSY || !(token.getNode() instanceof ManualTaskNode) || token.getNodeEnter() == null || !dateCutoff.getTime().before(token.getNodeEnter())) continue;
            this.manualTaskList.add(process);
        }
    }

    private ICacheService<WorkflowProcess> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    private void clearList() {
        this.processAlarmList.clear();
        this.manualTaskList.clear();
    }
}

