/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.internal.monitor.ManualTaskAlarmNotification;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessAlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class GenericAlarmNotificationProvider
implements IAlarmNotificationProvider {
    private static final Logger logger = Logger.getLogger(GenericAlarmNotificationProvider.class);
    public static final String ALARM_RECOVERY_URL = "/workflow/process/";
    public static final String CHILD_PROCESS_ERROR_MSG_PREFIX = "alarms.childProcess.error.prefix";
    private ProcessAlarmNotification processAlarmNotificationBuilder = new ProcessAlarmNotification();
    private ManualTaskAlarmNotification manualTaskAlarmNotificationBuilder = new ManualTaskAlarmNotification();
    private long totalTime = 0L;
    private long callCounter = 0L;

    public final Set<AlarmNotification> getAlarms(long timestamp) {
        long startTime = System.currentTimeMillis();
        HashSet<AlarmNotification> set = new HashSet<AlarmNotification>();
        Calendar dateCutoff = Calendar.getInstance();
        dateCutoff.setTimeInMillis(timestamp);
        ICacheService<WorkflowProcess> cache = this.getCache();
        block0: for (Serializable key : cache.getKeys()) {
            WorkflowProcess process = (WorkflowProcess)cache.get(key);
            if (process == null) continue;
            boolean foundError = false;
            boolean foundManualTasks = false;
            for (CustomToken token : process.findAllTokens()) {
                if (!foundError && this.processAlarmNotificationBuilder.match(token, dateCutoff)) {
                    AlarmNotification alarm = this.processAlarmNotificationBuilder.buildAlarm(process);
                    if (alarm != null) {
                        set.add(this.processAlarmNotificationBuilder.buildAlarm(process));
                    }
                } else if (!foundManualTasks && this.manualTaskAlarmNotificationBuilder.match(token, dateCutoff)) {
                    set.addAll(this.manualTaskAlarmNotificationBuilder.buildAlarmsForProcess(process));
                    foundManualTasks = true;
                }
                if (foundError && foundManualTasks) continue block0;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + set.size() + " process alarms."));
        }
        if (logger.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            long diff = endTime - startTime;
            ++this.callCounter;
            logger.debug((Object)("Elapsed milliseconds to build Alarms: " + diff));
            this.getAverageCallTime(diff);
        }
        return set;
    }

    private ICacheService<WorkflowProcess> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    private void getAverageCallTime(long diff) {
        this.totalTime += diff;
        logger.debug((Object)("Average millis per call: " + this.totalTime / this.callCounter));
    }
}

