/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsParameters;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.exe.Token;

public class WfsEsProcessHelper {
    private static Logger logger = Logger.getLogger(WfsEsProcessHelper.class);
    private static WfsEsProcessHelper instance = new WfsEsProcessHelper();
    private static final String TITLE_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
    private static final SimpleDateFormat titleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    private static final SimpleDateFormat displayDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    private WfsEsProcessHelper() {
    }

    public static WfsEsProcessHelper getInstance() {
        return instance;
    }

    public XContentBuilder createProcess(WorkflowProcess process) throws IOException {
        if (process == null || process.getId() < 1L || process.getRootToken() == null) {
            throw new IllegalArgumentException("Process appears to be invalid");
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.prettyPrint();
        builder.startObject();
        this.addSearchFields(builder, process);
        builder.endObject();
        return builder;
    }

    public boolean trySaving(String id, XContentBuilder source, TransportClient client) {
        if (client == null) {
            logger.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            IndexRequestBuilder bld = client.prepareIndex("wfs", "processinstance", id);
            bld.setSource(source);
            bld.execute().actionGet(3000L);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Could not index process " + id), (Throwable)e);
            return false;
        }
    }

    public boolean tryDeleting(String id, TransportClient client) {
        if (client == null) {
            logger.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            DeleteRequestBuilder bld = client.prepareDelete("wfs", "processinstance", id);
            bld.execute().actionGet(3000L);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Could not delete process " + id), (Throwable)e);
            return false;
        }
    }

    private void addSearchFields(XContentBuilder bldr, WorkflowProcess proc) {
        this.addSearchableField(bldr, "id", proc.getId());
        this.addSearchableField(bldr, "templateId", proc.getProcessDefinition().getId());
        this.addSearchableField(bldr, "templateName", proc.getProcessDefinition().getFullName());
        this.addSearchableField(bldr, "adminStatus", proc.getRootToken().getRequestedStatus());
        this.addSearchableField(bldr, "status", proc.getRootToken().getStatus());
        boolean titleIdFound = false;
        boolean titleBriefFound = false;
        boolean licenseStartFound = false;
        boolean licenseEndFound = false;
        boolean providerIdFound = false;
        boolean ingestTemplateFound = false;
        TokenVariableMap tMap = proc.getContextInstance().getTokenVariableMap((Token)proc.getRootToken());
        Iterator varItr = tMap.getVariables().keySet().iterator();
        while (varItr.hasNext()) {
            Date dtVal;
            if (titleIdFound && titleBriefFound && licenseStartFound && licenseEndFound && providerIdFound && ingestTemplateFound) break;
            String varName = (String)varItr.next();
            if ("titleId".equalsIgnoreCase(varName) || "title_id".equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, "titleId", tMap.getVariableInstance(varName).getValue());
                titleIdFound = true;
                continue;
            }
            if ("titleBrief".equalsIgnoreCase(varName) || "title_brief".equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, "titleBrief", tMap.getVariableInstance(varName).getValue());
                titleBriefFound = true;
                continue;
            }
            if ("licenseStart".equalsIgnoreCase(varName) || "license_start".equalsIgnoreCase(varName) || "licensingWindowStart".equalsIgnoreCase(varName)) {
                dtVal = null;
                if ("org.jbpm.context.exe.variableinstance.DateInstance".equalsIgnoreCase(tMap.getVariableInstance(varName).getClass().getName())) {
                    dtVal = (Date)tMap.getVariableInstance(varName).getValue();
                } else if ("org.jbpm.context.exe.variableinstance.StringInstance".equalsIgnoreCase(tMap.getVariableInstance(varName).getClass().getName())) {
                    dtVal = this.convertTitleStringToDate((String)tMap.getVariableInstance(varName).getValue());
                }
                if (dtVal != null) {
                    this.addSearchableField(bldr, "licenseStart", dtVal);
                }
                licenseStartFound = true;
                continue;
            }
            if ("licenseEnd".equalsIgnoreCase(varName) || "license_end".equalsIgnoreCase(varName) || "licensingWindowEnd".equalsIgnoreCase(varName)) {
                dtVal = null;
                if ("org.jbpm.context.exe.variableinstance.DateInstance".equalsIgnoreCase(tMap.getVariableInstance(varName).getClass().getName())) {
                    dtVal = (Date)tMap.getVariableInstance(varName).getValue();
                } else if ("org.jbpm.context.exe.variableinstance.StringInstance".equalsIgnoreCase(tMap.getVariableInstance(varName).getClass().getName())) {
                    dtVal = this.convertTitleStringToDate((String)tMap.getVariableInstance(varName).getValue());
                }
                if (dtVal != null) {
                    this.addSearchableField(bldr, "licenseEnd", dtVal);
                }
                licenseEndFound = true;
                continue;
            }
            if ("providerId".equalsIgnoreCase(varName) || "provider_id".equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, "providerId", tMap.getVariableInstance(varName).getValue());
                providerIdFound = true;
                continue;
            }
            if (!"ingestTemplate".equalsIgnoreCase(varName)) continue;
            this.addSearchableField(bldr, "ingestTemplate", tMap.getVariableInstance(varName).getValue());
            ingestTemplateFound = true;
        }
        this.addSearchableField(bldr, "isActive", proc.isActive());
        this.addSearchableField(bldr, "currentTask", proc.getRootToken().getCurrentNode().getName());
        if (proc.getStart() != null) {
            this.addSearchableField(bldr, "startTime", proc.getStart());
        }
        if (proc.getEnd() != null) {
            this.addSearchableField(bldr, "endTime", proc.getEnd());
        }
        if (proc.getSuperProcessToken() != null) {
            this.addSearchableField(bldr, "superProcessTokenId", proc.getSuperProcessToken().getId());
        } else {
            this.addSearchableField(bldr, "superProcessTokenId", null);
        }
        if (proc.getRootToken().getChildren() != null && proc.getRootToken().getChildren().size() > 0) {
            this.addSearchableField(bldr, "hasChildren", true);
        } else {
            this.addSearchableField(bldr, "hasChildren", false);
        }
        this.addSearchableField(bldr, "rootTokenId", proc.getRootToken().getId());
        if (proc.getRootToken().getErrorDetails() != null) {
            this.addSearchableField(bldr, "errorTime", proc.getRootToken().getErrorDetails().getTime());
            this.addSearchableField(bldr, "errorComment", proc.getRootToken().getErrorDetails().getMessage());
        }
    }

    private Date convertTitleStringToDate(String date) {
        Date retVal = null;
        if (date != null && !date.isEmpty()) {
            try {
                retVal = titleDateFormat.parse(date);
            }
            catch (ParseException e) {
                logger.warn((Object)("Date received from Title Service [" + date + "] is not in correct format. Expected format :" + TITLE_DATE_FORMAT), (Throwable)e);
            }
        }
        return retVal;
    }

    private void addSearchableField(XContentBuilder bldr, String key, Object value) {
        try {
            bldr.field(key, value);
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot add field", (Throwable)ex);
        }
    }

    public void addResultProperties(SearchRequestBuilder bld) {
        bld.addField("id");
        bld.addField("hasChildren");
        bld.addField("rootTokenId");
        bld.addField("superProcessTokenId");
        bld.addField("providerId");
        bld.addField("templateId");
        bld.addField("templateName");
        bld.addField("adminStatus");
        bld.addField("status");
        bld.addField("titleId");
        bld.addField("titleBrief");
        bld.addField("licenseStart");
        bld.addField("licenseEnd");
        bld.addField("currentTask");
        bld.addField("startTime");
        bld.addField("endTime");
        bld.addField("errorTime");
        bld.addField("errorComment");
        bld.addField("ingestTemplate");
        bld.addField("isActive");
    }

    public long getLongField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? -1L : Long.parseLong(value.toString());
    }

    public String getStringField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? "" : value.toString();
    }

    public int getIntField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? -1 : Integer.parseInt(value.toString());
    }

    public Date getDateField(SearchHit hit, String fieldName) throws ParseException {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? null : WfsEsParameters.dateformatter.parse(value.toString());
    }

    public boolean getBooleanField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? false : Boolean.parseBoolean(value.toString());
    }

    public WFSearchResult convert(SearchHit hit, long totalCount) {
        if (hit == null) {
            throw new IllegalArgumentException("SearchHit is null");
        }
        WFSearchResult result = new WFSearchResult();
        result.setProcessId(this.getLongField(hit, "id"));
        WFToken rootToken = new WFToken();
        rootToken.setTokenId(this.getLongField(hit, "rootTokenId"));
        rootToken.setProcessId(result.getProcessId());
        rootToken.setAdministrativeStatus(ProcessStatus.valueOf((String)this.getStringField(hit, "adminStatus")).ordinal());
        rootToken.setOperationalStatus(ProcessStatus.valueOf((String)this.getStringField(hit, "status")).ordinal());
        rootToken.setNodeName(this.getStringField(hit, "currentTask"));
        try {
            rootToken.setStartTime(this.getDateField(hit, "startTime"));
            rootToken.setEndTime(this.getDateField(hit, "endTime"));
            rootToken.setErrorTime(this.getDateField(hit, "errorTime"));
            rootToken.setErrorComment(this.getStringField(hit, "errorComment"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        result.setToken(rootToken);
        WFVariable titleId = new WFVariable();
        titleId.setName("titleId");
        titleId.addValue(this.getStringField(hit, "titleId"));
        result.addVariable(titleId);
        WFVariable titleBrief = new WFVariable();
        titleBrief.setName("titleBrief");
        titleBrief.addValue(this.getStringField(hit, "titleBrief"));
        result.addVariable(titleBrief);
        String selectorKey = this.getStringField(hit, "ingestTemplate");
        if (selectorKey != null && !selectorKey.isEmpty()) {
            WFVariable ingestTemplate = new WFVariable();
            ingestTemplate.setName("ingestTemplate");
            ingestTemplate.addValue(selectorKey);
            result.addVariable(ingestTemplate);
        }
        WFVariable isActive = new WFVariable();
        isActive.setName("isActive");
        isActive.addValue(this.getStringField(hit, "isActive"));
        result.addVariable(isActive);
        try {
            Date licenseStartDate = this.getDateField(hit, "licenseStart");
            if (licenseStartDate != null) {
                String licenseStartStr = displayDateFormat.format(this.getDateField(hit, "licenseStart"));
                WFVariable licenseStart = new WFVariable();
                licenseStart.setName("licenseStart");
                licenseStart.addValue(licenseStartStr);
                result.addVariable(licenseStart);
                WFVariable licenseStart1 = new WFVariable();
                licenseStart1.setName("licensingWindowStart");
                licenseStart1.addValue(licenseStartStr);
                result.addVariable(licenseStart1);
                WFVariable licenseStart2 = new WFVariable();
                licenseStart2.setName("license_start");
                licenseStart2.addValue(licenseStartStr);
                result.addVariable(licenseStart2);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Could not parse license start date", (Throwable)e);
        }
        try {
            Date licenseEndDate = this.getDateField(hit, "licenseEnd");
            if (licenseEndDate != null) {
                String licenseEndStr = displayDateFormat.format(this.getDateField(hit, "licenseEnd"));
                WFVariable licenseEnd = new WFVariable();
                licenseEnd.setName("licenseEnd");
                licenseEnd.addValue(licenseEndStr);
                result.addVariable(licenseEnd);
                WFVariable licenseEnd1 = new WFVariable();
                licenseEnd1.setName("licensingWindowEnd");
                licenseEnd1.addValue(licenseEndStr);
                result.addVariable(licenseEnd1);
                WFVariable licenseEnd2 = new WFVariable();
                licenseEnd2.setName("license_end");
                licenseEnd2.addValue(licenseEndStr);
                result.addVariable(licenseEnd2);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Could not parse license end date", (Throwable)e);
        }
        WFVariable providerId = new WFVariable();
        providerId.setName("providerId");
        providerId.addValue(this.getStringField(hit, "providerId"));
        result.addVariable(providerId);
        if (this.getBooleanField(hit, "hasChildren")) {
            result.addChild(new WFSearchResult());
            while (result.getToken().getAllChildren().size() <= 1) {
                result.getToken().addChild(new WFToken());
            }
        }
        result.setProcessDefinitionName(this.getStringField(hit, "templateName"));
        result.setSearchResultCount(totalCount);
        this.setNodeName(result.getProcessDefinitionName(), result.getToken());
        return result;
    }

    private void setNodeName(String templateName, final WFToken token) {
        ITemplateLoaderService templateLoaderService = (ITemplateLoaderService)ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        WorkflowTemplate template = templateLoaderService.getTemplateByFullName(templateName);
        if (template != null) {
            template.breadthFirstTraversal(new NodeVisitor(){

                public void visit(Node node) {
                    Node currentNode;
                    if (node instanceof SuperState && (currentNode = ((SuperState)node).getNode(token.getNodeName())) != null) {
                        token.setNodeName(node.getName());
                    }
                }
            });
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Singleton class does not allow cloning!");
    }
}

