/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.ISet;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSVariableInstance;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchService;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.elasticsearch.IWFSElasticSearchPersistanceHelper;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsParameters;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsPersistanceSynchronizer;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsProcessHelper;
import com.tandbergtv.workflow.driver.search.event.ProcessPersistEvent;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.io.FileReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.hibernate.SessionFactory;

public class WFSElasticSearchService
extends SearchService
implements IWFSElasticSearchPersistanceHelper,
IColleague {
    private static Logger logger = Logger.getLogger(WFSElasticSearchService.class);
    private static final String CONFIG_FILE = String.valueOf(System.getProperty("com.tandbergtv.cms.product.dir", "/opt/tandbergtv/cms")) + "/conf/workflow/WFSElasticSearch.properties";
    private static final boolean USE_HAZELCAST_TO_HANDLE_FAILED_ATTEMPT = System.getProperty("workflow.elasticsearch.sync.util", "").isEmpty();
    private TransportClient client;
    private WfsEsProcessHelper esProcessHelper = WfsEsProcessHelper.getInstance();
    private long writeTimeoutMs = 30000L;
    private long readTimeoutMs = 30000L;
    private static final String SAVE_FAILED_MAP = "ES_SAVE_MAP";
    private static final String DELETE_FAILED_MAP = "ES_DELETE_MAP";
    private ExecutorService executor = Executors.newFixedThreadPool(2);
    private IWFSElasticSearchPersistanceHelper persistanceHelper;
    private Thread asyncESSynchronizer;
    private boolean running = true;
    private ExecutorService esEventProcessor;

    public WFSElasticSearchService(SessionFactory factory) {
        super(factory);
    }

    @Override
    public String getServiceName() {
        return super.getServiceName();
    }

    @Override
    public void start() {
        logger.info((Object)"Starting WFSElasticSearch service...");
        try {
            Properties props = this.readConfiguration();
            this.initTimeouts(props);
            String clusterName = props.getProperty("cluster.name");
            logger.info((Object)("Cluster name: " + clusterName));
            Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", clusterName).build();
            this.client = new TransportClient(settings);
            String hosts = props.getProperty("hosts");
            StringTokenizer tkz = new StringTokenizer(hosts, ",; ");
            while (tkz.hasMoreTokens()) {
                String hostEntry = tkz.nextToken().trim();
                if (hostEntry.length() <= 0) continue;
                int port = 9300;
                String host = hostEntry;
                int idx = hostEntry.indexOf(58);
                if (idx > 0) {
                    try {
                        port = Integer.parseInt(hostEntry.substring(idx + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    host = hostEntry.substring(0, idx);
                }
                this.client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(host, port));
                logger.info((Object)("Added host: " + host + ":" + port));
            }
            this.esEventProcessor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setName("Elasticsearch Event Processor");
                    t.setDaemon(true);
                    return t;
                }
            });
            DefaultMediator.getInstance().register((IColleague)this);
            this.persistanceHelper = this;
            this.running = true;
            this.asyncESSynchronizer = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (WFSElasticSearchService.this.running) {
                        if (USE_HAZELCAST_TO_HANDLE_FAILED_ATTEMPT && Cluster.isMaster()) {
                            WfsEsPersistanceSynchronizer synchronizer;
                            Long procId;
                            int n;
                            int n2;
                            Long[] longArray;
                            Long[] wip;
                            ISet failedSet = Hazelcast.getSet((String)WFSElasticSearchService.DELETE_FAILED_MAP);
                            if (failedSet != null) {
                                longArray = wip = failedSet.toArray(new Long[failedSet.size()]);
                                n2 = wip.length;
                                n = 0;
                                while (n < n2) {
                                    procId = longArray[n];
                                    failedSet.remove(procId);
                                    synchronizer = new WfsEsPersistanceSynchronizer(procId, WFSElasticSearchService.this.persistanceHelper, true);
                                    WFSElasticSearchService.this.executor.execute(synchronizer);
                                    ++n;
                                }
                            }
                            if ((failedSet = Hazelcast.getSet((String)WFSElasticSearchService.SAVE_FAILED_MAP)) != null) {
                                longArray = wip = failedSet.toArray(new Long[failedSet.size()]);
                                n2 = wip.length;
                                n = 0;
                                while (n < n2) {
                                    procId = longArray[n];
                                    failedSet.remove(procId);
                                    synchronizer = new WfsEsPersistanceSynchronizer(procId, WFSElasticSearchService.this.persistanceHelper, false);
                                    WFSElasticSearchService.this.executor.execute(synchronizer);
                                    ++n;
                                }
                            }
                        }
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    WFSElasticSearchService.this.executor.shutdown();
                }
            });
            this.asyncESSynchronizer.start();
            logger.info((Object)"Started WFSElasticSearch service");
        }
        catch (Exception e) {
            logger.error((Object)"Could not connect to ElasticSearch.", (Throwable)e);
        }
    }

    private Properties readConfiguration() throws Exception {
        FileReader reader = new FileReader(CONFIG_FILE);
        Properties props = new Properties();
        props.load(reader);
        reader.close();
        return props;
    }

    private void initTimeouts(Properties props) {
        int tmp;
        try {
            tmp = Integer.parseInt(props.getProperty("timeout.read"));
            this.readTimeoutMs = tmp < 3 ? 3000L : (tmp > 30 ? 30000L : (long)(1000 * tmp));
        }
        catch (Exception ex) {
            this.readTimeoutMs = 15000L;
        }
        logger.info((Object)("Read timeout: " + this.readTimeoutMs / 1000L));
        try {
            tmp = Integer.parseInt(props.getProperty("timeout.write"));
            this.writeTimeoutMs = tmp < 3 ? 3000L : (tmp > 30 ? 30000L : (long)(1000 * tmp));
        }
        catch (Exception ex) {
            this.writeTimeoutMs = 15000L;
        }
        logger.info((Object)("Write timeout: " + this.writeTimeoutMs / 1000L));
    }

    @Override
    public void stop() {
        logger.info((Object)"Stopping ElasticSearch service...");
        this.esEventProcessor.shutdown();
        if (this.asyncESSynchronizer != null) {
            this.asyncESSynchronizer.interrupt();
        }
        this.running = false;
        DefaultMediator.getInstance().unregister((IColleague)this);
        try {
            this.client.close();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.info((Object)"Stopped ElasticSearch service.");
    }

    private void softDelete(WorkflowProcess process) throws Exception {
        this.save(process);
    }

    @Override
    public void save(WorkflowProcess process) throws Exception {
        if (process == null || process.getId() < 1L || process.getRootToken() == null) {
            return;
        }
        String procId = String.valueOf(process.getId());
        logger.info((Object)("Saving process[" + procId + "]"));
        XContentBuilder source = this.esProcessHelper.createProcess(process);
        try {
            long t1 = System.currentTimeMillis();
            while (!this.esProcessHelper.trySaving(procId, source, this.client)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long t2 = System.currentTimeMillis();
                if (t2 - t1 <= this.writeTimeoutMs) continue;
                this.saveFailedProcessId(process.getId(), false);
                return;
            }
        }
        finally {
            source.close();
        }
    }

    private void saveFailedProcessId(long id, boolean deleting) {
        if (!USE_HAZELCAST_TO_HANDLE_FAILED_ATTEMPT) {
            logger.fatal((Object)("Failed attempt of saving process Id " + id + " to reindex later for " + (deleting ? "delete" : "save") + " operation."));
            System.out.println("Failed attempt of saving process Id " + id + " to reindex later for " + (deleting ? "delete" : "save") + " operation.");
            System.exit(2);
            return;
        }
        logger.info((Object)("Saving process Id " + id + " to reindex later for " + (deleting ? "delete" : "save") + " operation."));
        ISet failedSet = deleting ? Hazelcast.getSet((String)DELETE_FAILED_MAP) : Hazelcast.getSet((String)SAVE_FAILED_MAP);
        failedSet.add(id);
    }

    @Override
    public void delete(long id) throws Exception {
        String procId = String.valueOf(id);
        logger.info((Object)("Deleting process[" + procId + "]"));
        long t1 = System.currentTimeMillis();
        while (!this.esProcessHelper.tryDeleting(procId, this.client)) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long t2 = System.currentTimeMillis();
            if (t2 - t1 <= this.writeTimeoutMs) continue;
            this.saveFailedProcessId(id, true);
            return;
        }
    }

    private List<WFSearchResult> expressSearchGetChildren(List<SearchParameterBase> whereList, List<SearchParameterBase> sortList) {
        long start = System.currentTimeMillis();
        String parentIdPredicate = null;
        boolean hidesubprocess = false;
        for (SearchParameterBase param : whereList) {
            String esPropertyName = WfsEsParameters.mapUIColumnToESProperty(param.getFieldName());
            if ("id".equalsIgnoreCase(esPropertyName)) {
                parentIdPredicate = param.getPredicate();
                parentIdPredicate = parentIdPredicate.substring(parentIdPredicate.indexOf("= ") + 2);
                continue;
            }
            if (!"hidesubprocess".equalsIgnoreCase(param.getFieldName())) continue;
            hidesubprocess = true;
        }
        ArrayList<WFSearchResult> processes = new ArrayList<WFSearchResult>();
        processes.add(this.convertProcess(parentIdPredicate, hidesubprocess));
        logger.debug((Object)("Total getChildren: " + (System.currentTimeMillis() - start) + " ms."));
        return processes;
    }

    private WFSearchResult convertProcess(String processIdAsString, boolean hidesubprocess) {
        WorkflowProcess proc = ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).get(Long.valueOf(Long.parseLong(processIdAsString)));
        WFSearchResult result = new WFSearchResult();
        result.setProcessId(proc.getId());
        result.setProcessDefinitionName(proc.getProcessDefinition().getFullName());
        result.setRootTokenId(proc.getRootToken().getId());
        WFToken token = new WFToken();
        result.setToken(token);
        this.convertToken(proc.getRootToken(), token, result, hidesubprocess);
        if (proc.getSuperProcessToken() == null) {
            Set vars = proc.getVariables();
            Iterator varItr = vars.iterator();
            int varsFound = 0;
            while (varItr.hasNext()) {
                WFSVariableInstance var = (WFSVariableInstance)varItr.next();
                if (!"titleId".equalsIgnoreCase(var.getName()) && !"title_id".equalsIgnoreCase(var.getName()) && !"titlebrief".equalsIgnoreCase(var.getName()) && !"title_brief".equalsIgnoreCase(var.getName()) && !"licensestart".equalsIgnoreCase(var.getName()) && !"license_start".equalsIgnoreCase(var.getName()) && !"licenseend".equalsIgnoreCase(var.getName()) && !"license_end".equalsIgnoreCase(var.getName()) && !"ingestTemplate".equalsIgnoreCase(var.getName()) && !"providerid".equalsIgnoreCase(var.getName()) && !"provider_id".equalsIgnoreCase(var.getName())) continue;
                this.addVar(result.getVariables(), var);
                if (++varsFound >= 6) break;
            }
        }
        return result;
    }

    private void addVar(Map<String, WFVariable> wfVariables, WFSVariableInstance var) {
        WFVariable newVar = new WFVariable();
        newVar.setName(var.getName());
        newVar.addValue(var.getStringVal());
        wfVariables.put(newVar.getName(), newVar);
    }

    private void convertToken(CustomToken rootToken, WFToken token, WFSearchResult result, boolean hidesubprocess) {
        token.setAdministrativeStatus(rootToken.getRequestedStatus().ordinal());
        token.setEndTime(rootToken.getEnd());
        if (rootToken.getErrorDetails() != null) {
            token.setErrorComment(rootToken.getErrorDetails().getMessage());
            token.setErrorTime(rootToken.getErrorDetails().getTime());
        }
        token.setNodeName(rootToken.getCurrentNode().getName());
        token.setOperationalStatus(rootToken.getStatus().ordinal());
        token.setProcessId(rootToken.getProcessInstance().getId());
        token.setStartTime(rootToken.getStart());
        token.setTokenId(rootToken.getId());
        if (!hidesubprocess) {
            SearchRequestBuilder bld = this.client.prepareSearch(new String[]{"wfs"});
            this.esProcessHelper.addResultProperties(bld);
            AndFilterBuilder filterBuilder = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
            filterBuilder.add((FilterBuilder)FilterBuilders.termFilter((String)"superProcessTokenId", (long)rootToken.getId()));
            filterBuilder.add((FilterBuilder)FilterBuilders.termFilter((String)"isActive", (Object)true));
            bld.setPostFilter((FilterBuilder)filterBuilder);
            SearchResponse resp = (SearchResponse)bld.execute().actionGet(this.readTimeoutMs);
            SearchHit[] searchHitArray = resp.getHits().hits();
            int n = searchHitArray.length;
            int n2 = 0;
            while (n2 < n) {
                SearchHit hit = searchHitArray[n2];
                result.addChild(this.convertProcess("" + this.esProcessHelper.getLongField(hit, "id"), hidesubprocess));
                ++n2;
            }
        }
        for (CustomToken child : rootToken.getChildTokens()) {
            WFToken chld = new WFToken();
            this.convertToken(child, chld, result, hidesubprocess);
            token.addChild(chld);
        }
    }

    @Override
    public List<WFSearchResult> expressSearch(SearchCriteria searchCriteria) {
        logger.debug((Object)"Starting expressSearch --> ");
        List searchParameters = searchCriteria.getSearchList();
        ArrayList<SearchParameterBase> sortList = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> whereList = new ArrayList<SearchParameterBase>();
        boolean getChildren = false;
        for (SearchParameterBase param : searchParameters) {
            if (param instanceof SortParameter) {
                sortList.add(param);
                continue;
            }
            if (param.getPartialWhereClause() == null) continue;
            if ("getChildren".equalsIgnoreCase(param.getFieldName())) {
                getChildren = true;
                continue;
            }
            whereList.add(param);
        }
        if (getChildren) {
            return this.expressSearchGetChildren(whereList, sortList);
        }
        return this.expressSearchTopLevelProcesses(searchCriteria, whereList, sortList);
    }

    private List<WFSearchResult> expressSearchTopLevelProcesses(SearchCriteria searchCriteria, List<SearchParameterBase> whereList, List<SearchParameterBase> sortList) {
        long topLevelStart = System.currentTimeMillis();
        SearchRequestBuilder bld = this.client.prepareSearch(new String[]{"wfs"});
        this.esProcessHelper.addResultProperties(bld);
        for (SearchParameterBase sortParam : sortList) {
            FieldSortBuilder sort = SortBuilders.fieldSort((String)WfsEsParameters.mapUIColumnToESProperty(sortParam.getFieldName()));
            sort.order(SortingOrder.DESCENDING.equals((Object)sortParam.getSortingOrder()) ? SortOrder.DESC : SortOrder.ASC);
            sort.ignoreUnmapped(true);
            bld.addSort((SortBuilder)sort);
        }
        bld.setFrom(searchCriteria.getStartingRecordNumber());
        if (searchCriteria.getRecordsCount() > 0) {
            bld.setSize(searchCriteria.getRecordsCount());
        }
        AndFilterBuilder filterBuilder = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
        filterBuilder.add((FilterBuilder)FilterBuilders.termFilter((String)"isActive", (Object)true));
        for (SearchParameterBase param : whereList) {
            String esPropertyName = WfsEsParameters.mapUIColumnToESProperty(param.getFieldName());
            String predicate = param.getPredicate();
            if ("id".equalsIgnoreCase(esPropertyName)) {
                filterBuilder.add(this.buildEqualCondition(esPropertyName, predicate));
                continue;
            }
            if ("titleBrief".equalsIgnoreCase(esPropertyName)) {
                filterBuilder.add(this.buildLikeCondition(esPropertyName, predicate));
                continue;
            }
            if ("titleId".equalsIgnoreCase(esPropertyName)) {
                if (param.getClass().getName().equalsIgnoreCase("com.tandbergtv.watchpoint.pmm.title.activity.TitleKeysParameter")) {
                    predicate = param.getPartialWhereClause();
                    if (predicate.indexOf(".stringVal is not null") > 0) {
                        filterBuilder.add((FilterBuilder)FilterBuilders.existsFilter((String)esPropertyName));
                        continue;
                    }
                    filterBuilder.add(this.buildListCondition(esPropertyName, predicate.substring(predicate.indexOf(".stringVal")).replaceAll("'", "")));
                    continue;
                }
                filterBuilder.add(this.buildEqualCondition(esPropertyName, predicate.replaceAll("'", "")));
                continue;
            }
            if ("templateId".equalsIgnoreCase(esPropertyName)) {
                filterBuilder.add(this.buildListCondition(esPropertyName, predicate));
                continue;
            }
            if ("status".equalsIgnoreCase(esPropertyName)) {
                if (predicate.trim().startsWith("IN")) {
                    filterBuilder.add(this.buildStatusListCondition(esPropertyName, param.getPartialWhereClause()));
                    continue;
                }
                if (!predicate.trim().startsWith("=")) continue;
                filterBuilder.add(this.buildStatusListCondition(esPropertyName, param.getPartialWhereClause()));
                continue;
            }
            if ("startTime".equalsIgnoreCase(esPropertyName)) {
                try {
                    filterBuilder.add(this.buildDateRangeCondition(esPropertyName, predicate));
                }
                catch (ParseException e) {
                    logger.error((Object)"Date parsing error", (Throwable)e);
                }
                continue;
            }
            if (!"superProcessTokenId".equalsIgnoreCase(esPropertyName)) continue;
            filterBuilder.add((FilterBuilder)FilterBuilders.missingFilter((String)esPropertyName));
        }
        bld.setPostFilter((FilterBuilder)filterBuilder);
        long startTime = System.currentTimeMillis();
        SearchResponse resp = (SearchResponse)bld.execute().actionGet(this.readTimeoutMs);
        logger.debug((Object)("actionGet: " + (System.currentTimeMillis() - startTime) + " ms."));
        ArrayList<WFSearchResult> processes = new ArrayList<WFSearchResult>();
        long totalHits = resp.getHits().totalHits();
        startTime = System.currentTimeMillis();
        SearchHit[] searchHitArray = resp.getHits().hits();
        int n = searchHitArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchHit hit = searchHitArray[n2];
            processes.add(this.esProcessHelper.convert(hit, totalHits));
            ++n2;
        }
        logger.debug((Object)("Object conversions: " + (System.currentTimeMillis() - startTime) + " ms."));
        logger.debug((Object)("Total top level expressSearch: " + (System.currentTimeMillis() - topLevelStart) + " ms."));
        return processes;
    }

    private FilterBuilder buildEqualCondition(String propertyName, String rawPredicate) {
        return FilterBuilders.termFilter((String)propertyName, (String)rawPredicate.substring(rawPredicate.indexOf("= ") + 2));
    }

    private FilterBuilder buildLikeCondition(String propertyName, String rawPredicate) {
        rawPredicate = (rawPredicate = rawPredicate.trim().replaceAll("'", "")).startsWith("=") ? rawPredicate.substring(1).trim() : rawPredicate.trim();
        String predicate = rawPredicate.contains("%") ? rawPredicate.substring(rawPredicate.indexOf(37) + 1, rawPredicate.lastIndexOf(37)) : rawPredicate;
        return FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.matchPhraseQuery((String)propertyName, (Object)predicate));
    }

    private FilterBuilder buildListCondition(String propertyName, String rawPredicate) {
        String[] idList = rawPredicate.substring(rawPredicate.indexOf(40) + 1, rawPredicate.indexOf(41)).split(",");
        return FilterBuilders.inFilter((String)propertyName, (String[])idList);
    }

    private FilterBuilder buildStatusListCondition(String propertyName, String rawPredicate) {
        String[] idList = rawPredicate.substring(rawPredicate.indexOf(40) + 1, rawPredicate.indexOf(41)).split(",");
        int index = 0;
        String[] stringArray = idList;
        int n = idList.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Integer iid = Integer.parseInt(id);
            idList[index++] = ProcessStatus.values()[iid].name();
            ++n2;
        }
        return FilterBuilders.inFilter((String)propertyName, (String[])idList);
    }

    private FilterBuilder buildDateRangeCondition(String propertyName, String rawPredicate) throws ParseException {
        RangeFilterBuilder builder = null;
        if ((rawPredicate = rawPredicate.trim().replace("yyyy-mm-dd hh24:mi:ss", "yyyy-MM-dd HH:mm:ss")).startsWith("between")) {
            String[] dateParts = rawPredicate.split("AND");
            String[] fromDnF = dateParts[0].substring(dateParts[0].indexOf(40) + 1, dateParts[0].indexOf(41)).split(",");
            String[] toDnF = dateParts[1].substring(dateParts[1].indexOf(40) + 1, dateParts[1].indexOf(41)).split(",");
            SimpleDateFormat fromSdf = new SimpleDateFormat(fromDnF[1].trim().replaceAll("'", ""));
            Date fromDate = fromSdf.parse(fromDnF[0].trim().replaceAll("'", ""));
            SimpleDateFormat toSdf = new SimpleDateFormat(toDnF[1].trim().replaceAll("'", ""));
            Date toDate = toSdf.parse(toDnF[0].trim().replaceAll("'", ""));
            builder = FilterBuilders.rangeFilter((String)propertyName).includeLower(true).includeUpper(true);
            builder.from((Object)fromDate);
            builder.to((Object)toDate);
        } else {
            String[] dateNformat = rawPredicate.substring(rawPredicate.indexOf(40) + 1, rawPredicate.indexOf(41)).split(",");
            SimpleDateFormat sdf = new SimpleDateFormat(dateNformat[1].trim().replaceAll("'", ""));
            Date range = sdf.parse(dateNformat[0].trim().replaceAll("'", ""));
            builder = FilterBuilders.rangeFilter((String)propertyName);
            if (rawPredicate.trim().startsWith(">=")) {
                builder.gte((Object)range);
            } else if (rawPredicate.trim().startsWith("<=")) {
                builder.lte((Object)range);
            } else if (rawPredicate.trim().startsWith("<")) {
                builder.lt((Object)range);
            } else if (rawPredicate.trim().startsWith(">")) {
                builder.gt((Object)range);
            }
        }
        return builder;
    }

    @Override
    public int expressCount(SearchCriteria criteria) {
        List<WFSearchResult> result = this.expressSearch(criteria);
        return result == null || result.size() == 0 ? 0 : (int)result.get(0).getSearchResultCount();
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        if (event instanceof ProcessPersistEvent) {
            this.esEventProcessor.execute(new ESPersistanceProcessor(event));
        }
    }

    @Override
    public int ingestCount(Date from) {
        SearchRequestBuilder bld = this.client.prepareSearch(new String[]{"wfs"});
        this.esProcessHelper.addResultProperties(bld);
        bld.setSize(1);
        AndFilterBuilder filterBuilder = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
        filterBuilder.add((FilterBuilder)FilterBuilders.rangeFilter((String)"endTime").gte((Object)from));
        filterBuilder.add((FilterBuilder)FilterBuilders.termFilter((String)"status", (String)"COMPLETED"));
        filterBuilder.add((FilterBuilder)FilterBuilders.existsFilter((String)"ingestTemplate"));
        bld.setPostFilter((FilterBuilder)filterBuilder);
        SearchResponse resp = (SearchResponse)bld.execute().actionGet(this.readTimeoutMs);
        long totalHits = resp.getHits().totalHits();
        return (int)totalHits;
    }

    private class ESPersistanceProcessor
    implements Runnable {
        private WorkflowEvent event;

        public ESPersistanceProcessor(WorkflowEvent evt) {
            this.event = evt;
        }

        @Override
        public void run() {
            try {
                if (((ProcessPersistEvent)this.event).isDeleted()) {
                    if (((ProcessPersistEvent)this.event).getProcess().isActive()) {
                        WFSElasticSearchService.this.delete(((ProcessPersistEvent)this.event).getProcess().getId());
                    } else {
                        WFSElasticSearchService.this.softDelete(((ProcessPersistEvent)this.event).getProcess());
                    }
                } else {
                    WFSElasticSearchService.this.save(((ProcessPersistEvent)this.event).getProcess());
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to persist in ElasticSearch", (Throwable)e);
            }
        }
    }
}

