/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.elasticsearch.IWFSElasticSearchPersistanceHelper;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import org.apache.log4j.Logger;

public class WfsEsPersistanceSynchronizer
implements Runnable {
    private static Logger logger = Logger.getLogger(WfsEsPersistanceSynchronizer.class);
    private Long processId;
    private IWFSElasticSearchPersistanceHelper espHelper;
    private boolean forDeletion;

    public WfsEsPersistanceSynchronizer(Long processId, IWFSElasticSearchPersistanceHelper helper, boolean forDeletion) {
        this.processId = processId;
        this.espHelper = helper;
        this.forDeletion = forDeletion;
    }

    @Override
    public void run() {
        try {
            if (this.forDeletion) {
                this.espHelper.delete(this.processId);
            } else {
                WorkflowProcess proc = ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).get(this.processId);
                if (proc == null) {
                    logger.info((Object)("Process [id:" + this.processId + "] found in failed-to-save queue but is not found in RDBMS. Forcing Delete from Elastic Search."));
                    this.espHelper.delete(this.processId);
                } else {
                    this.espHelper.save(proc);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Could not synchronize process[" + this.processId + "] with Elastic Search"), (Throwable)e);
        }
    }
}

