/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.driver.service.IAuthorizationManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public final class AuthorizationManager
implements IAuthorizationManager {
    private static final Logger logger = Logger.getLogger(AuthorizationManager.class);
    private SessionFactory factory;

    public AuthorizationManager(SessionFactory factory) {
        this.factory = factory;
    }

    public void start() {
    }

    public void stop() {
        logger.debug((Object)"Authorization manager destroyed");
    }

    public String getServiceName() {
        return "Authorization Manager";
    }

    @Override
    public List<ProtectionKey> getAllProtectionKeys() {
        Session session = this.getSession();
        ArrayList<ProtectionKey> protectionKeys = new ArrayList<ProtectionKey>();
        try {
            List list = session.createCriteria(ProtectionKey.class).addOrder(Order.asc((String)"name")).list();
            for (Object obj : list) {
                protectionKeys.add((ProtectionKey)obj);
            }
        }
        finally {
            this.closeSession(session);
        }
        return protectionKeys;
    }

    @Override
    public ProtectionKey getProtectionKey(int protKeyID) {
        List<ProtectionKey> protKeys = this.getAllProtectionKeys();
        for (ProtectionKey protKey : protKeys) {
            if (protKeyID != protKey.getId()) continue;
            return protKey;
        }
        return null;
    }

    @Override
    public ProtectionKey getProtectionKey(String name) {
        for (ProtectionKey key : this.getAllProtectionKeys()) {
            if (!name.equals(key.getName())) continue;
            return key;
        }
        return null;
    }

    @Override
    public void addProtectionKey(ProtectionKey key) {
        this.save(key);
    }

    @Override
    public int getProtectionKeyIDForName(String protKeyName, boolean createIfNotExists) {
        for (ProtectionKey protectionKey : this.getAllProtectionKeys()) {
            if (protectionKey == null || protectionKey.getName() == null || !protectionKey.getName().equals(protKeyName)) continue;
            return protectionKey.getId();
        }
        if (createIfNotExists) {
            ProtectionKey protectionKey;
            logger.info((Object)("Creating a new protection key in database | Protection Key Name: " + protKeyName));
            protectionKey = new ProtectionKey();
            protectionKey.setName(protKeyName);
            this.save(protectionKey);
            return this.getProtectionKeyIDForName(protKeyName, false);
        }
        return -1;
    }

    private Object save(Object entity) {
        Session session = this.getSession();
        Transaction t = session.beginTransaction();
        try {
            try {
                session.save(entity);
                t.commit();
            }
            catch (RuntimeException e) {
                if (t != null) {
                    t.rollback();
                }
                throw e;
            }
        }
        finally {
            this.closeSession(session);
        }
        return entity;
    }

    private Session getSession() {
        return this.factory.openSession();
    }

    private void closeSession(Session session) {
        session.close();
    }
}

