/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class ResumeToken
extends TokenCallable {
    private static final long serialVersionUID = 1419483303521779562L;

    public ResumeToken(CustomToken token) {
        super(token);
    }

    @Override
    protected Callable<CustomToken> innerCallable(final CustomToken token) {
        return new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                try {
                    WorkflowProcess process = token.getProcessInstance();
                    if (!ProcessFinder.isOwner(process) || !ProcessFinder.hasOwner(process)) {
                        ProcessFinder.updateOwner(process);
                    }
                    token.resume();
                    ResumeToken.this.counter().resumed(token);
                }
                catch (StackOverflowError e) {
                    ResumeToken.this.handleStackOverflowError(token, e);
                }
                catch (Throwable t) {
                    Logger.getLogger(ResumeToken.class).error((Object)token, t);
                }
                return token;
            }
        };
    }
}

